/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.runtime.rete;

import com.bstek.urule.Utils;
import com.bstek.urule.debug.MsgType;
import com.bstek.urule.model.rule.lhs.Criteria;
import com.bstek.urule.model.rule.lhs.EvaluateResponse;
import com.bstek.urule.runtime.rete.AbstractActivity;
import com.bstek.urule.runtime.rete.Context;
import com.bstek.urule.runtime.rete.EvaluationContext;
import com.bstek.urule.runtime.rete.FactTracker;
import com.bstek.urule.runtime.rete.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CriteriaActivity
extends AbstractActivity {
    protected Criteria criteria;
    private boolean pass;
    private boolean debug;

    public CriteriaActivity(Criteria criteria, boolean debug) {
        this.criteria = criteria;
        this.debug = debug;
    }

    public List<FactTracker> enter(EvaluationContext context, Object obj, FactTracker tracker, Map<String, Object> variableMap) {
        if (this.pass) {
            return null;
        }
        if (this.orNodeIsPassed()) {
            return null;
        }
        ArrayList<Object> allMatchedObjects = new ArrayList<Object>();
        EvaluateResponse response = null;
        String criteriaId = this.criteria.getId();
        Object storeValue = context.getCriteriaValue(criteriaId);
        if (storeValue != null) {
            response = (EvaluateResponse)storeValue;
        } else {
            response = this.criteria.evaluate(context, obj, allMatchedObjects);
            context.storeCriteriaValue(criteriaId, response);
        }
        boolean result = response.getResult();
        this.doDebug(response, context);
        if (result) {
            context.setPrevActivity(this);
            this.pass = true;
            tracker.addObjectCriteria(obj, this.criteria);
            for (Object e : allMatchedObjects) {
                tracker.addObjectCriteria(e, this.criteria);
            }
            return this.visitPahs(context, obj, tracker, variableMap);
        }
        return null;
    }

    private void doDebug(EvaluateResponse response, Context context) {
        if (!this.debug || !Utils.isDebug()) {
            return;
        }
        String id = this.criteria.getId();
        StringBuffer sb = new StringBuffer();
        sb.append("^^^\u6761\u4ef6\uff1a" + id);
        String result = response.getResult() ? "\u6ee1\u8db3" : "\u4e0d\u6ee1\u8db3";
        sb.append(" =>" + result);
        sb.append(", \u5de6\u503c\uff1a" + (response.getLeftResult() == null ? "null" : response.getLeftResult()));
        sb.append(", \u53f3\u503c\uff1a" + (response.getRightResult() == null ? "null" : response.getRightResult()));
        context.debugMsg(sb.toString(), MsgType.Condition, this.debug);
    }

    @Override
    public boolean orNodeIsPassed() {
        List<Path> paths = this.getPaths();
        if (paths != null) {
            if (paths.size() > 1) {
                return false;
            }
            if (paths.size() == 1) {
                Path path = paths.get(0);
                AbstractActivity activity = (AbstractActivity)path.getTo();
                return activity.orNodeIsPassed();
            }
        }
        return false;
    }

    @Override
    public void reset() {
        this.pass = false;
    }
}

