/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.runtime.rete;

import com.bstek.urule.Utils;
import com.bstek.urule.debug.MessageItem;
import com.bstek.urule.debug.MsgType;
import com.bstek.urule.runtime.ElCalculator;
import com.bstek.urule.runtime.WorkingMemory;
import com.bstek.urule.runtime.assertor.AssertorEvaluator;
import com.bstek.urule.runtime.rete.Context;
import com.bstek.urule.runtime.rete.ValueCompute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.ApplicationContext;

public class ContextImpl
implements Context {
    private ApplicationContext applicationContext;
    private AssertorEvaluator assertorEvaluator;
    private Map<String, String> variableCategoryMap;
    private ValueCompute valueCompute;
    private WorkingMemory workingMemory;
    private List<MessageItem> debugMessageItems;
    private ElCalculator elCalculator = new ElCalculator();

    public ContextImpl(WorkingMemory workingMemory, ApplicationContext applicationContext, Map<String, String> variableCategoryMap, List<MessageItem> debugMessageItems) {
        this.workingMemory = workingMemory;
        this.applicationContext = applicationContext;
        this.assertorEvaluator = (AssertorEvaluator)applicationContext.getBean("urule.assertorEvaluator");
        this.variableCategoryMap = variableCategoryMap;
        this.debugMessageItems = debugMessageItems;
        this.valueCompute = (ValueCompute)applicationContext.getBean("urule.valueCompute");
    }

    @Override
    public WorkingMemory getWorkingMemory() {
        return this.workingMemory;
    }

    @Override
    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Override
    public AssertorEvaluator getAssertorEvaluator() {
        return this.assertorEvaluator;
    }

    @Override
    public Object parseExpression(String expression) {
        return this.elCalculator.eval(expression);
    }

    @Override
    public void debugMsg(String msg, MsgType type, boolean enableDebug) {
        if (!Utils.isDebug() || !enableDebug) {
            return;
        }
        if (!Utils.isDebugToFile()) {
            System.out.println(msg);
            return;
        }
        MessageItem item = new MessageItem(msg, type);
        this.debugMessageItems.add(item);
    }

    @Override
    public List<MessageItem> getDebugMessageItems() {
        return this.debugMessageItems;
    }

    @Override
    public String getVariableCategoryClass(String variableCategory) {
        String clazz = this.variableCategoryMap.get(variableCategory);
        if (StringUtils.isEmpty((String)clazz)) {
            clazz = HashMap.class.getName();
        }
        return clazz;
    }

    @Override
    public ValueCompute getValueCompute() {
        return this.valueCompute;
    }
}

