/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.runtime.rete;

import com.bstek.urule.runtime.rete.Activity;
import com.bstek.urule.runtime.rete.EvaluationContext;
import com.bstek.urule.runtime.rete.FactTracker;
import com.bstek.urule.runtime.rete.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractActivity
implements Activity {
    private List<Path> paths;

    @Override
    public List<Path> getPaths() {
        return this.paths;
    }

    public void addPath(Path path) {
        if (this.paths == null) {
            this.paths = new ArrayList<Path>();
        }
        this.paths.add(path);
    }

    protected List<FactTracker> visitPahs(EvaluationContext context, Object obj, FactTracker tracker, Map<String, Object> variableMap) {
        if (this.paths == null || this.paths.size() == 0) {
            return null;
        }
        ArrayList<FactTracker> trackers = null;
        int size = this.paths.size();
        for (Path path : this.paths) {
            Collection<FactTracker> results = null;
            Activity activity = path.getTo();
            path.setPassed(true);
            if (size > 0) {
                HashMap<String, Object> newVariableMap = new HashMap<String, Object>();
                newVariableMap.putAll(variableMap);
                results = activity.enter(context, obj, tracker.newSubFactTracker(), newVariableMap);
            } else {
                results = activity.enter(context, obj, tracker, variableMap);
            }
            if (results == null) continue;
            if (trackers == null) {
                trackers = new ArrayList<FactTracker>();
            }
            trackers.addAll(results);
        }
        return trackers;
    }

    public abstract boolean orNodeIsPassed();

    public abstract void reset();
}

