/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.runtime.builtinaction;

import com.bstek.urule.RuleException;
import com.bstek.urule.Utils;
import com.bstek.urule.model.library.action.annotation.ActionBean;
import com.bstek.urule.model.library.action.annotation.ActionMethod;
import com.bstek.urule.model.library.action.annotation.ActionMethodParameter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

@ActionBean(name="List\u96c6\u5408")
public class ListAction {
    @ActionMethod(name="\u6c42List\u5927\u5c0f")
    @ActionMethodParameter(names={"\u96c6\u5408\u5bf9\u8c61"})
    public int size(List<Object> list) {
        return list.size();
    }

    @ActionMethod(name="\u6c42List\u4e2d\u6240\u6709\u7684\u6570\u5b57\u6700\u5927\u503c")
    @ActionMethodParameter(names={"\u5305\u542b\u6240\u6709\u6570\u5b57\u7684\u96c6\u5408\u5bf9\u8c61"})
    public Number max(List<Object> list) {
        double max = Double.MIN_VALUE;
        for (Object obj : list) {
            BigDecimal v = Utils.toBigDecimal(obj);
            max = Math.max(max, v.doubleValue());
        }
        return max;
    }

    @ActionMethod(name="\u6c42List\u4e2d\u6240\u6709\u7684\u6570\u5b57\u6700\u5c0f\u503c")
    @ActionMethodParameter(names={"\u5305\u542b\u6240\u6709\u6570\u5b57\u7684\u96c6\u5408\u5bf9\u8c61"})
    public Number min(List<Object> list) {
        if (list.size() == 0) {
            throw new RuleException("Number list can not be null when compute min value from list.");
        }
        double min = Double.MAX_VALUE;
        for (Object obj : list) {
            BigDecimal v = Utils.toBigDecimal(obj);
            min = Math.min(min, v.doubleValue());
        }
        return min;
    }

    @ActionMethod(name="\u5411List\u4e2d\u6dfb\u52a0\u5bf9\u8c61")
    @ActionMethodParameter(names={"\u96c6\u5408\u5bf9\u8c61", "\u8981\u6dfb\u52a0\u7684\u5bf9\u8c61"})
    public void add(List<Object> list, Object obj) {
        list.add(obj);
    }

    @ActionMethod(name="\u96c6\u5408\u6392\u5e8f")
    @ActionMethodParameter(names={"\u96c6\u5408\u5bf9\u8c61", "\u5c5e\u6027\u540d", "\u6392\u5e8f\u65b9\u5f0f"})
    public List<Object> sort(List<Object> list, final String propertyName, String type) {
        final boolean asc = this.asc(type);
        Collections.sort(list, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                String prop;
                String[] props;
                int result = 0;
                String[] stringArray = props = propertyName.split(",");
                int n = stringArray.length;
                for (int i = 0; i < n && (result = this.objectCompare(prop = stringArray[i], asc, o1, o2)) == 0; ++i) {
                }
                return result;
            }

            private int objectCompare(String propertyName2, boolean asc2, Object o1, Object o2) {
                Object v1 = Utils.getObjectProperty(o1, propertyName2);
                Object v2 = Utils.getObjectProperty(o2, propertyName2);
                if (v1 == null) {
                    if (asc2) {
                        return 0;
                    }
                    return 1;
                }
                if (v2 == null) {
                    if (asc2) {
                        return 1;
                    }
                    return 0;
                }
                if (v1 instanceof String) {
                    if (asc2) {
                        return ((String)v1).compareTo(v2.toString());
                    }
                    return ((String)v2).compareTo(v1.toString());
                }
                if (v1 instanceof Date) {
                    if (asc2) {
                        return ((Date)v1).compareTo((Date)v2);
                    }
                    return ((Date)v2).compareTo((Date)v1);
                }
                if (v1 instanceof Number) {
                    BigDecimal b1 = Utils.toBigDecimal(v1);
                    BigDecimal b2 = Utils.toBigDecimal(v2);
                    if (asc2) {
                        return b1.compareTo(b2);
                    }
                    return b2.compareTo(b1);
                }
                return 0;
            }
        });
        return list;
    }

    private boolean asc(String type) {
        if (type == null) {
            return true;
        }
        return type.equals("1") || type.equals("true") || type.equals("\u6b63\u5e8f");
    }

    @ActionMethod(name="\u62bd\u53d6\u96c6\u5408\u5c5e\u6027")
    @ActionMethodParameter(names={"\u96c6\u5408\u5bf9\u8c61", "\u5c5e\u6027\u540d"})
    public List<Object> retrive(List<Object> list, String propertyName) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (list == null) {
            return result;
        }
        for (Object obj : list) {
            Object value = Utils.getObjectProperty(obj, propertyName);
            result.add(value);
        }
        return result;
    }

    @ActionMethod(name="\u4eceList\u4e2d\u5220\u9664\u5bf9\u8c61")
    @ActionMethodParameter(names={"\u96c6\u5408\u5bf9\u8c61", "\u8981\u5220\u9664\u7684\u5bf9\u8c61"})
    public void remove(List<Object> list, Object obj) {
        list.remove(obj);
    }

    @ActionMethod(name="\u6307\u5b9a\u5bf9\u8c61\u662f\u5426\u5b58\u5728")
    @ActionMethodParameter(names={"\u96c6\u5408\u5bf9\u8c61", "\u8981\u5224\u65ad\u7684\u5bf9\u8c61"})
    public boolean contains(List<Object> list, Object obj) {
        return list.contains(obj);
    }

    @ActionMethod(name="List\u662f\u5426\u4e3a\u7a7a")
    @ActionMethodParameter(names={"\u96c6\u5408\u5bf9\u8c61"})
    public boolean isEmpty(List<Object> list) {
        return list.isEmpty();
    }
}

