/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.runtime.builtinaction;

import com.bstek.urule.RuleException;
import com.bstek.urule.model.library.action.annotation.ActionBean;
import com.bstek.urule.model.library.action.annotation.ActionMethod;
import com.bstek.urule.model.library.action.annotation.ActionMethodParameter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang.StringUtils;

@ActionBean(name="\u65e5\u671f")
public class DateAction {
    @ActionMethod(name="\u89e3\u6790\u5b57\u7b26\u4e32\u4e3a\u65e5\u671f")
    @ActionMethodParameter(names={"\u65e5\u671f\u5b57\u7b26\u4e32", "\u683c\u5f0f"})
    public Date formatString(String dateStr, String pattern) {
        if (StringUtils.isBlank((String)dateStr)) {
            return null;
        }
        SimpleDateFormat sd = new SimpleDateFormat(pattern);
        try {
            return sd.parse(dateStr);
        }
        catch (ParseException e) {
            throw new RuleException(e);
        }
    }

    @ActionMethod(name="\u5f53\u524d\u65e5\u671f")
    @ActionMethodParameter(names={})
    public Date getDate() {
        return new Date();
    }

    @ActionMethod(name="\u683c\u5f0f\u5316\u65e5\u671f")
    @ActionMethodParameter(names={"\u76ee\u6807\u65e5\u671f", "\u683c\u5f0f"})
    public String format(Date date, String pattern) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat sd = new SimpleDateFormat(pattern);
        return sd.format(date);
    }

    @ActionMethod(name="\u52a0\u65e5\u671f")
    @ActionMethodParameter(names={"\u76ee\u6807\u65e5\u671f", "\u5e74\u6570", "\u6708\u6570", "\u5929\u6570", "\u5c0f\u65f6", "\u5206\u949f", "\u79d2\u6570"})
    public Date addDate(Date date, int years, int months, int days, int hours, int minutes, int seconds) {
        if (date == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(1, years);
        c.add(2, months);
        c.add(5, days);
        c.add(11, hours);
        c.add(12, minutes);
        c.add(13, seconds);
        return c.getTime();
    }

    @ActionMethod(name="\u65e5\u671f\u52a0\u5e74")
    @ActionMethodParameter(names={"\u76ee\u6807\u65e5\u671f", "\u5e74\u6570"})
    public Date addDateForYear(Date date, int years) {
        if (date == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(1, years);
        return c.getTime();
    }

    @ActionMethod(name="\u65e5\u671f\u52a0\u6708")
    @ActionMethodParameter(names={"\u76ee\u6807\u65e5\u671f", "\u6708\u6570"})
    public Date addDateForMonth(Date date, int months) {
        if (date == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(2, months);
        return c.getTime();
    }

    @ActionMethod(name="\u65e5\u671f\u52a0\u5929")
    @ActionMethodParameter(names={"\u76ee\u6807\u65e5\u671f", "\u5929\u6570"})
    public Date addDateForDay(Date date, int days) {
        if (date == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(5, days);
        return c.getTime();
    }

    @ActionMethod(name="\u65e5\u671f\u52a0\u5c0f\u65f6")
    @ActionMethodParameter(names={"\u76ee\u6807\u65e5\u671f", "\u5c0f\u65f6\u6570"})
    public Date addDateForHour(Date date, int hours) {
        if (date == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(11, hours);
        return c.getTime();
    }

    @ActionMethod(name="\u65e5\u671f\u52a0\u5206\u949f")
    @ActionMethodParameter(names={"\u76ee\u6807\u65e5\u671f", "\u5206\u949f\u6570"})
    public Date addDateForMinute(Date date, int minutes) {
        if (date == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(12, minutes);
        return c.getTime();
    }

    @ActionMethod(name="\u65e5\u671f\u52a0\u79d2")
    @ActionMethodParameter(names={"\u76ee\u6807\u65e5\u671f", "\u79d2\u6570"})
    public Date addDateForSecond(Date date, int seconds) {
        if (date == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(13, seconds);
        return c.getTime();
    }

    @ActionMethod(name="\u51cf\u65e5\u671f")
    @ActionMethodParameter(names={"\u76ee\u6807\u65e5\u671f", "\u5e74\u6570", "\u6708\u6570", "\u5929\u6570", "\u5c0f\u65f6", "\u5206\u949f", "\u79d2\u6570"})
    public Date subDate(Date date, int years, int months, int days, int hours, int minutes, int seconds) {
        if (date == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(1, -years);
        c.add(2, -months);
        c.add(5, -days);
        c.add(11, -hours);
        c.add(12, -minutes);
        c.add(13, -seconds);
        return c.getTime();
    }

    @ActionMethod(name="\u51cf\u65e5\u671f\u51cf\u5e74")
    @ActionMethodParameter(names={"\u76ee\u6807\u65e5\u671f", "\u5e74\u6570"})
    public Date subDateForYear(Date date, int years) {
        if (date == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(1, -years);
        return c.getTime();
    }

    @ActionMethod(name="\u51cf\u65e5\u671f\u51cf\u6708")
    @ActionMethodParameter(names={"\u76ee\u6807\u65e5\u671f", "\u6708\u6570"})
    public Date subDateForMonth(Date date, int months) {
        if (date == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(2, -months);
        return c.getTime();
    }

    @ActionMethod(name="\u51cf\u65e5\u671f\u51cf\u5929")
    @ActionMethodParameter(names={"\u76ee\u6807\u65e5\u671f", "\u5929\u6570"})
    public Date subDateForDay(Date date, int days) {
        if (date == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(5, -days);
        return c.getTime();
    }

    @ActionMethod(name="\u51cf\u65e5\u671f\u51cf\u5c0f\u65f6")
    @ActionMethodParameter(names={"\u76ee\u6807\u65e5\u671f", "\u5c0f\u65f6"})
    public Date subDateForHour(Date date, int hours) {
        if (date == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(11, -hours);
        return c.getTime();
    }

    @ActionMethod(name="\u51cf\u65e5\u671f\u51cf\u5206\u949f")
    @ActionMethodParameter(names={"\u76ee\u6807\u65e5\u671f", "\u5206\u949f"})
    public Date subDateForMinute(Date date, int minutes) {
        if (date == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(12, -minutes);
        return c.getTime();
    }

    @ActionMethod(name="\u51cf\u65e5\u671f\u51cf\u79d2")
    @ActionMethodParameter(names={"\u76ee\u6807\u65e5\u671f", "\u79d2\u6570"})
    public Date subDateForSecond(Date date, int seconds) {
        if (date == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(13, -seconds);
        return c.getTime();
    }

    @ActionMethod(name="\u53d6\u5e74\u4efd")
    @ActionMethodParameter(names={"\u76ee\u6807\u65e5\u671f"})
    public Object getYear(Date date) {
        if (date == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(1);
    }

    @ActionMethod(name="\u53d6\u6708\u4efd")
    @ActionMethodParameter(names={"\u76ee\u6807\u65e5\u671f"})
    public Object getMonth(Date date) {
        if (date == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(2);
    }

    @ActionMethod(name="\u53d6\u661f\u671f")
    @ActionMethodParameter(names={"\u76ee\u6807\u65e5\u671f"})
    public Object getWeek(Date date) {
        if (date == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(7);
    }

    @ActionMethod(name="\u53d6\u5929")
    @ActionMethodParameter(names={"\u76ee\u6807\u65e5\u671f"})
    public Object getay(Date date) {
        if (date == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(5);
    }

    @ActionMethod(name="\u53d6\u5c0f\u65f6")
    @ActionMethodParameter(names={"\u76ee\u6807\u65e5\u671f"})
    public Object getHour(Date date) {
        if (date == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(11);
    }

    @ActionMethod(name="\u53d6\u5206\u949f")
    @ActionMethodParameter(names={"\u76ee\u6807\u65e5\u671f"})
    public Object getMinute(Date date) {
        if (date == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(12);
    }

    @ActionMethod(name="\u53d6\u79d2")
    @ActionMethodParameter(names={"\u76ee\u6807\u65e5\u671f"})
    public Object getSecond(Date date) {
        if (date == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(13);
    }

    @ActionMethod(name="\u65e5\u671f\u76f8\u51cf\u8fd4\u56de\u6beb\u79d2")
    @ActionMethodParameter(names={"\u65e5\u671f", "\u51cf\u53bb\u7684\u65e5\u671f"})
    public Object dateDifMillSecond(Date d1, Date d2) {
        if (d1 == null || d2 == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(d1);
        Calendar c1 = Calendar.getInstance();
        c1.setTime(d2);
        long a = c.getTimeInMillis();
        long b = c1.getTimeInMillis();
        return a - b;
    }

    @ActionMethod(name="\u65e5\u671f\u76f8\u51cf\u8fd4\u56de\u79d2")
    @ActionMethodParameter(names={"\u65e5\u671f", "\u51cf\u53bb\u7684\u65e5\u671f"})
    public Object dateDifSecond(Date d1, Date d2) {
        if (d1 == null || d2 == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(d1);
        Calendar c1 = Calendar.getInstance();
        c1.setTime(d2);
        long a = c.getTimeInMillis();
        long b = c1.getTimeInMillis();
        return (a - b) / 1000L;
    }

    @ActionMethod(name="\u65e5\u671f\u76f8\u51cf\u8fd4\u56de\u5206\u949f")
    @ActionMethodParameter(names={"\u65e5\u671f", "\u51cf\u53bb\u7684\u65e5\u671f"})
    public Object dateDifMinute(Date d1, Date d2) {
        if (d1 == null || d2 == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(d1);
        Calendar c1 = Calendar.getInstance();
        c1.setTime(d2);
        long a = c.getTimeInMillis();
        long b = c1.getTimeInMillis();
        return (a - b) / 60000L;
    }

    @ActionMethod(name="\u65e5\u671f\u76f8\u51cf\u8fd4\u56de\u5c0f\u65f6")
    @ActionMethodParameter(names={"\u65e5\u671f", "\u51cf\u53bb\u7684\u65e5\u671f"})
    public Object dateDifHour(Date d1, Date d2) {
        if (d1 == null || d2 == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(d1);
        Calendar c1 = Calendar.getInstance();
        c1.setTime(d2);
        long a = c.getTimeInMillis();
        long b = c1.getTimeInMillis();
        return (a - b) / 3600000L;
    }

    @ActionMethod(name="\u65e5\u671f\u76f8\u51cf\u8fd4\u56de\u5929")
    @ActionMethodParameter(names={"\u65e5\u671f", "\u51cf\u53bb\u7684\u65e5\u671f"})
    public Object dateDifDay(Date d1, Date d2) {
        if (d1 == null || d2 == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(d1);
        Calendar c1 = Calendar.getInstance();
        c1.setTime(d2);
        long a = c.getTimeInMillis();
        long b = c1.getTimeInMillis();
        return (a - b) / 86400000L;
    }

    @ActionMethod(name="\u65e5\u671f\u76f8\u51cf\u8fd4\u56de\u661f\u671f")
    @ActionMethodParameter(names={"\u65e5\u671f", "\u51cf\u53bb\u7684\u65e5\u671f"})
    public Object dateDifWeek(Date d1, Date d2) {
        if (d1 == null || d2 == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(d1);
        Calendar c1 = Calendar.getInstance();
        c1.setTime(d2);
        long a = c.getTimeInMillis();
        long b = c1.getTimeInMillis();
        return (a - b) / 604800000L;
    }

    @ActionMethod(name="\u65e5\u671f\u76f8\u51cf\u8fd4\u56de\u6708")
    @ActionMethodParameter(names={"\u65e5\u671f", "\u51cf\u53bb\u7684\u65e5\u671f"})
    public Object dateDifMonth(Date d1, Date d2) {
        if (d1 == null || d2 == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(d1);
        Calendar c1 = Calendar.getInstance();
        c1.setTime(d2);
        int year1 = c.get(1);
        int year2 = c1.get(1);
        int month1 = c.get(2);
        int month2 = c1.get(2);
        int result = 12 * (year1 - year2) + (month1 - month2);
        return result;
    }
}

