/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.runtime.assertor;

import com.bstek.urule.Utils;
import com.bstek.urule.model.library.Datatype;
import com.bstek.urule.model.rule.Op;
import com.bstek.urule.runtime.assertor.Assertor;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;

public class GreaterThenEqualsAssertor
implements Assertor {
    @Override
    public boolean eval(Object left, Object right, Datatype datatype) {
        if (left == null || right == null) {
            return false;
        }
        if (datatype.equals((Object)Datatype.Date)) {
            Date leftDate = (Date)datatype.convert(left);
            Date rightDate = (Date)datatype.convert(right);
            Calendar leftCalendar = Calendar.getInstance();
            leftCalendar.setTime(leftDate);
            Calendar rightCalendar = Calendar.getInstance();
            rightCalendar.setTime(rightDate);
            int result = leftCalendar.compareTo(rightCalendar);
            if (result == 1 || result == 0) {
                return true;
            }
        } else {
            BigDecimal rightNumber;
            BigDecimal leftNumber = Utils.toBigDecimal(left);
            int result = leftNumber.compareTo(rightNumber = Utils.toBigDecimal(right));
            if (result == 1 || result == 0) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean support(Op op) {
        return op.equals((Object)Op.GreaterThenEquals);
    }
}

