/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.runtime.assertor;

import com.bstek.urule.Utils;
import com.bstek.urule.model.library.Datatype;
import com.bstek.urule.model.rule.Op;
import com.bstek.urule.runtime.assertor.Assertor;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;

public class EqualsAssertor
implements Assertor {
    @Override
    public boolean eval(Object left, Object right, Datatype datatype) {
        if (left == null && right == null) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        BigDecimal b1 = null;
        BigDecimal b2 = null;
        switch (datatype) {
            case String: {
                return left.toString().equals(right.toString());
            }
            case Boolean: {
                return left.toString().equals(right.toString());
            }
            case Date: {
                Date ld = (Date)datatype.convert(left);
                Date rd = (Date)datatype.convert(right);
                Calendar leftCalendar = Calendar.getInstance();
                leftCalendar.setTime(ld);
                Calendar rightCalendar = Calendar.getInstance();
                rightCalendar.setTime(rd);
                return leftCalendar.compareTo(rightCalendar) == 0;
            }
            case Double: {
                b1 = Utils.toBigDecimal(left);
                b2 = Utils.toBigDecimal(right);
                return b1.compareTo(b2) == 0;
            }
            case Float: {
                b1 = Utils.toBigDecimal(left);
                b2 = Utils.toBigDecimal(right);
                return b1.compareTo(b2) == 0;
            }
            case Integer: {
                b1 = Utils.toBigDecimal(left);
                b2 = Utils.toBigDecimal(right);
                return b1.compareTo(b2) == 0;
            }
            case Long: {
                b1 = Utils.toBigDecimal(left);
                b2 = Utils.toBigDecimal(right);
                return b1.compareTo(b2) == 0;
            }
            case BigDecimal: {
                b1 = Utils.toBigDecimal(left);
                b2 = Utils.toBigDecimal(right);
                return b1.compareTo(b2) == 0;
            }
            case Enum: {
                Enum e1 = (Enum)left;
                if (right instanceof Enum) {
                    Enum e2 = (Enum)right;
                    return e1.equals(e2);
                }
                Object e2 = Enum.valueOf(e1.getClass(), right.toString());
                return e1.equals(e2);
            }
        }
        return right.toString().equals(left.toString());
    }

    @Override
    public boolean support(Op op) {
        return op.equals((Object)Op.Equals);
    }
}

