/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.runtime.assertor;

import com.bstek.urule.RuleException;
import com.bstek.urule.model.library.Datatype;
import com.bstek.urule.model.rule.Op;
import com.bstek.urule.runtime.assertor.Assertor;
import java.util.Collection;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class AssertorEvaluator
implements ApplicationContextAware {
    public static final String BEAN_ID = "urule.assertorEvaluator";
    private Collection<Assertor> assertors;

    public boolean evaluate(Object left, Object right, Datatype datatype, Op op) {
        Assertor targetAssertor = null;
        for (Assertor assertor : this.assertors) {
            if (!assertor.support(op)) continue;
            targetAssertor = assertor;
            break;
        }
        if (targetAssertor == null) {
            throw new RuleException("Unsupport op:" + (Object)((Object)op));
        }
        return targetAssertor.eval(left, right, datatype);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.assertors = applicationContext.getBeansOfType(Assertor.class).values();
    }
}

