/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.runtime.agenda;

import com.bstek.urule.action.ActionValue;
import com.bstek.urule.model.rule.Rule;
import com.bstek.urule.model.rule.RuleInfo;
import com.bstek.urule.runtime.agenda.Activation;
import com.bstek.urule.runtime.agenda.AgendaFilter;
import com.bstek.urule.runtime.rete.Context;
import java.util.ArrayList;
import java.util.List;

public abstract class RuleGroup {
    private String name;
    protected List<RuleInfo> executedRules;
    protected List<Activation> activations = new ArrayList<Activation>();

    public RuleGroup(String name, List<RuleInfo> executedRules) {
        this.name = name;
        this.executedRules = executedRules;
    }

    public abstract List<RuleInfo> execute(Context var1, AgendaFilter var2, int var3, List<ActionValue> var4);

    public static Activation fetchNextExecutableActivation(List<Activation> activations) {
        Activation targetActivation = null;
        for (Activation ac : activations) {
            if (ac.isProcessed()) continue;
            targetActivation = ac;
            break;
        }
        return targetActivation;
    }

    public List<Activation> getActivations() {
        return this.activations;
    }

    public String getName() {
        return this.name;
    }

    public boolean contains(Rule rule) {
        for (Activation activation : this.activations) {
            if (!activation.getRule().equals(rule)) continue;
            return true;
        }
        return false;
    }
}

