/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.runtime.agenda;

import com.bstek.urule.action.ActionValue;
import com.bstek.urule.model.rule.Rule;
import com.bstek.urule.model.rule.RuleInfo;
import com.bstek.urule.runtime.agenda.AbstractRuleBox;
import com.bstek.urule.runtime.agenda.Activation;
import com.bstek.urule.runtime.agenda.AgendaFilter;
import com.bstek.urule.runtime.agenda.AgendaGroup;
import com.bstek.urule.runtime.agenda.RuleBox;
import com.bstek.urule.runtime.rete.Context;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class AgendaGroupRuleBox
extends AbstractRuleBox {
    private Map<String, AgendaGroup> agendaGroupMap = new HashMap<String, AgendaGroup>();

    public AgendaGroupRuleBox(Context context, List<RuleInfo> executedRules) {
        super(context, executedRules);
    }

    @Override
    public List<RuleInfo> execute(AgendaFilter filter, int max, List<ActionValue> actionValues) {
        ArrayList<RuleInfo> ruleInfos = new ArrayList<RuleInfo>();
        AgendaGroup ag = this.findNextAgendaGroup();
        while (ag != null) {
            List<RuleInfo> ruleInfoResult = ag.execute(this.context, filter, max, actionValues);
            ruleInfos.addAll(ruleInfoResult);
            if (ruleInfos.size() >= max) break;
            ag = this.findNextAgendaGroup();
        }
        return ruleInfos;
    }

    public AgendaGroup findNextAgendaGroup() {
        for (AgendaGroup ag : this.agendaGroupMap.values()) {
            if (ag.isExecuted()) continue;
            return ag;
        }
        return null;
    }

    @Override
    public RuleBox next() {
        AgendaGroup group = this.findNextAgendaGroup();
        if (group != null) {
            return this;
        }
        return null;
    }

    public AgendaGroup getAgendaGroup(String agendaGroupName) {
        return this.agendaGroupMap.get(agendaGroupName);
    }

    @Override
    public void clean() {
        this.executedRules.clear();
        this.agendaGroupMap.clear();
        this.rules.clear();
    }

    @Override
    public void retract(Object obj) {
        for (AgendaGroup group : this.agendaGroupMap.values()) {
            List<Activation> activations = group.getActivations();
            super.retract(obj, activations);
        }
    }

    @Override
    public boolean add(Activation activation) {
        boolean shouldAdd = this.activationShouldAdd(activation);
        if (!shouldAdd) {
            return false;
        }
        Rule rule = activation.getRule();
        String agendaGroup = rule.getAgendaGroup();
        if (StringUtils.isEmpty((String)agendaGroup)) {
            return false;
        }
        AgendaGroup group = this.agendaGroupMap.get(agendaGroup);
        if (group == null) {
            group = new AgendaGroup(agendaGroup, this.executedRules);
            this.agendaGroupMap.put(agendaGroup, group);
        }
        List<Activation> list = group.getActivations();
        this.addActivation(activation, list);
        this.rules.add(activation.getRule());
        return true;
    }
}

