/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.runtime.agenda;

import com.bstek.urule.action.ActionValue;
import com.bstek.urule.model.rule.RuleInfo;
import com.bstek.urule.runtime.agenda.Activation;
import com.bstek.urule.runtime.agenda.ActivationImpl;
import com.bstek.urule.runtime.agenda.AgendaFilter;
import com.bstek.urule.runtime.agenda.RuleGroup;
import com.bstek.urule.runtime.rete.Context;
import java.util.ArrayList;
import java.util.List;

public class AgendaGroup
extends RuleGroup {
    private boolean focus;
    private boolean executed;

    public AgendaGroup(String name, List<RuleInfo> executedRules) {
        super(name, executedRules);
    }

    @Override
    public List<RuleInfo> execute(Context context, AgendaFilter filter, int max, List<ActionValue> actionValues) {
        this.executed = true;
        ArrayList<RuleInfo> ruleInfos = new ArrayList<RuleInfo>();
        for (int i = 0; i < max; ++i) {
            Activation activation = AgendaGroup.fetchNextExecutableActivation(this.activations);
            if (activation == null) {
                return ruleInfos;
            }
            this.activations.remove(activation);
            ActivationImpl ac = (ActivationImpl)activation;
            ac.setProcessed(true);
            boolean autoFocus = false;
            if (activation.getRule().getAutoFocus() != null) {
                autoFocus = activation.getRule().getAutoFocus();
            }
            RuleInfo ruleInfo = null;
            if (this.focus) {
                ruleInfo = activation.execute(context, this.executedRules, actionValues);
            } else if (autoFocus) {
                ruleInfo = activation.execute(context, this.executedRules, actionValues);
            }
            if (ruleInfo != null) {
                ruleInfos.add(ruleInfo);
            }
            if (ruleInfos.size() >= max) break;
        }
        return ruleInfos;
    }

    public boolean isExecuted() {
        return this.executed;
    }

    public boolean isFocus() {
        return this.focus;
    }

    public void setFocus(boolean focus) {
        this.focus = focus;
    }
}

