/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.runtime.agenda;

import com.bstek.urule.action.ActionValue;
import com.bstek.urule.model.rule.RuleInfo;
import com.bstek.urule.runtime.KnowledgeSessionImpl;
import com.bstek.urule.runtime.WorkingMemory;
import com.bstek.urule.runtime.agenda.Activation;
import com.bstek.urule.runtime.agenda.ActivationGroupRuleBox;
import com.bstek.urule.runtime.agenda.ActivationRuleBox;
import com.bstek.urule.runtime.agenda.AgendaFilter;
import com.bstek.urule.runtime.agenda.AgendaGroupRuleBox;
import com.bstek.urule.runtime.agenda.RuleBox;
import com.bstek.urule.runtime.response.ExecutionResponseImpl;
import com.bstek.urule.runtime.response.RuleExecutionResponse;
import com.bstek.urule.runtime.rete.Context;
import com.bstek.urule.runtime.rete.FactTracker;
import com.bstek.urule.runtime.rete.ReteInstance;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class Agenda {
    private Context context;
    private List<RuleBox> ruleBoxes = new ArrayList<RuleBox>();
    private List<RuleInfo> matchedRules = new ArrayList<RuleInfo>();

    public Agenda(WorkingMemory workingMemory, Context context) {
        this.context = context;
        this.ruleBoxes.add(new AgendaGroupRuleBox(context, this.matchedRules));
        this.ruleBoxes.add(new ActivationGroupRuleBox(context, this.matchedRules));
        this.ruleBoxes.add(new ActivationRuleBox(context, this.matchedRules));
    }

    public RuleExecutionResponse execute(AgendaFilter filter, int max) {
        ExecutionResponseImpl response = new ExecutionResponseImpl();
        ArrayList<ActionValue> actionValues = new ArrayList<ActionValue>();
        response.setActionValues(actionValues);
        ArrayList<RuleInfo> firedRules = new ArrayList<RuleInfo>();
        RuleBox ruleBox = this.nextRuleBox();
        while (ruleBox != null) {
            List<RuleInfo> ruleInfoResult = ruleBox.execute(filter, max - firedRules.size(), actionValues);
            if (ruleInfoResult != null && ruleInfoResult.size() > 0) {
                firedRules.addAll(ruleInfoResult);
            }
            if (firedRules.size() >= max) break;
            ruleBox = this.nextRuleBox();
        }
        KnowledgeSessionImpl session = (KnowledgeSessionImpl)this.context.getWorkingMemory();
        List<ReteInstance> reteInstanceList = session.getReteInstanceList();
        for (ReteInstance reteInstance : reteInstanceList) {
            reteInstance.reset();
        }
        session.getAllFacts().clear();
        response.setFiredRules(firedRules);
        response.addMatchedRules(this.matchedRules);
        return response;
    }

    private RuleBox nextRuleBox() {
        for (RuleBox ruleBox : this.ruleBoxes) {
            RuleBox next = ruleBox.next();
            if (next == null) continue;
            return next;
        }
        return null;
    }

    public void addTrackers(Collection<FactTracker> list) {
        for (FactTracker tracker : list) {
            RuleBox ruleBox;
            boolean add;
            Activation activation = tracker.getActivation();
            Iterator<RuleBox> iterator = this.ruleBoxes.iterator();
            while (iterator.hasNext() && !(add = (ruleBox = iterator.next()).add(activation))) {
            }
        }
    }

    public void retract(Object obj) {
        for (RuleBox ruleBox : this.ruleBoxes) {
            ruleBox.retract(obj);
        }
    }

    public List<RuleBox> getRuleBoxes() {
        return this.ruleBoxes;
    }

    public void clean() {
        for (RuleBox ruleBox : this.ruleBoxes) {
            ruleBox.clean();
        }
    }
}

