/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.runtime.agenda;

import com.bstek.urule.action.ActionValue;
import com.bstek.urule.model.rule.RuleInfo;
import com.bstek.urule.runtime.agenda.AbstractRuleBox;
import com.bstek.urule.runtime.agenda.Activation;
import com.bstek.urule.runtime.agenda.ActivationImpl;
import com.bstek.urule.runtime.agenda.AgendaFilter;
import com.bstek.urule.runtime.agenda.RuleBox;
import com.bstek.urule.runtime.agenda.RuleGroup;
import com.bstek.urule.runtime.rete.Context;
import java.util.ArrayList;
import java.util.List;

public class ActivationRuleBox
extends AbstractRuleBox {
    private List<Activation> activations = new ArrayList<Activation>();

    public ActivationRuleBox(Context context, List<RuleInfo> executedRules) {
        super(context, executedRules);
    }

    @Override
    public List<RuleInfo> execute(AgendaFilter filter, int max, List<ActionValue> actionValues) {
        Activation activation = this.findNextActivation();
        ArrayList<RuleInfo> ruleInfos = new ArrayList<RuleInfo>();
        while (activation != null) {
            ActivationImpl ac = (ActivationImpl)activation;
            ac.setProcessed(true);
            if (filter != null && !filter.accept(activation)) continue;
            if (ruleInfos.size() >= max) break;
            RuleInfo ruleInfo = activation.execute(this.context, this.executedRules, actionValues);
            if (ruleInfo != null) {
                ruleInfos.add(ruleInfo);
            }
            activation = RuleGroup.fetchNextExecutableActivation(this.activations);
        }
        return ruleInfos;
    }

    public Activation findNextActivation() {
        return RuleGroup.fetchNextExecutableActivation(this.activations);
    }

    @Override
    public RuleBox next() {
        Activation activation = this.findNextActivation();
        if (activation != null) {
            return this;
        }
        return null;
    }

    @Override
    public void clean() {
        this.executedRules.clear();
        this.activations.clear();
        this.rules.clear();
    }

    @Override
    public void retract(Object obj) {
        super.retract(obj, this.activations);
    }

    @Override
    public boolean add(Activation activation) {
        boolean shouldAdd = this.activationShouldAdd(activation);
        if (!shouldAdd) {
            return false;
        }
        this.rules.add(activation.getRule());
        return this.addActivation(activation, this.activations);
    }
}

