/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.runtime.agenda;

import com.bstek.urule.action.Action;
import com.bstek.urule.action.ActionValue;
import com.bstek.urule.model.GeneralEntity;
import com.bstek.urule.model.rule.Rhs;
import com.bstek.urule.model.rule.Rule;
import com.bstek.urule.model.rule.RuleInfo;
import com.bstek.urule.model.rule.lhs.BaseCriteria;
import com.bstek.urule.model.rule.lhs.EvaluateResponse;
import com.bstek.urule.model.rule.loop.LoopRule;
import com.bstek.urule.model.scorecard.runtime.ScoreRule;
import com.bstek.urule.runtime.KnowledgeSession;
import com.bstek.urule.runtime.agenda.Activation;
import com.bstek.urule.runtime.event.impl.ActivationAfterFiredEventImpl;
import com.bstek.urule.runtime.event.impl.ActivationBeforeFiredEventImpl;
import com.bstek.urule.runtime.rete.Context;
import com.bstek.urule.runtime.rete.EvaluationContext;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ActivationImpl
implements Activation {
    private boolean processed;
    private Rule rule;
    private Map<String, Object> variableMap;
    private Map<Object, List<BaseCriteria>> objectCriteriaMap = new HashMap<Object, List<BaseCriteria>>();

    public ActivationImpl(Rule rule, Map<String, Object> variableMap) {
        this.rule = rule;
        this.variableMap = variableMap;
    }

    @Override
    public RuleInfo execute(Context context, List<RuleInfo> executedRules, List<ActionValue> actionValues) {
        KnowledgeSession session = (KnowledgeSession)context.getWorkingMemory();
        session.fireEvent(new ActivationBeforeFiredEventImpl(this, session));
        executedRules.add(this.rule);
        boolean enabled = true;
        if (this.rule.getEnabled() != null) {
            enabled = this.rule.getEnabled();
        }
        if (!enabled) {
            return null;
        }
        Date now = new Date();
        Date effectiveDate = this.rule.getEffectiveDate();
        if (effectiveDate != null && effectiveDate.getTime() > now.getTime()) {
            return null;
        }
        Date expiresDate = this.rule.getExpiresDate();
        if (expiresDate != null && expiresDate.getTime() < now.getTime()) {
            return null;
        }
        ArrayList<Object> matchedObjects = new ArrayList<Object>();
        matchedObjects.addAll(this.objectCriteriaMap.keySet());
        if (this.rule instanceof LoopRule) {
            LoopRule loopRule = (LoopRule)this.rule;
            List<ActionValue> values = loopRule.execute(context, this.objectCriteriaMap.keySet(), matchedObjects, this.variableMap);
            if (values != null) {
                actionValues.addAll(values);
            }
        } else if (this.rule instanceof ScoreRule) {
            ScoreRule scoreRule = (ScoreRule)this.rule;
            scoreRule.execute(context, this.objectCriteriaMap.keySet(), matchedObjects, this.variableMap);
        } else {
            List<Action> actions;
            Rhs rhs = this.rule.getRhs();
            if (rhs != null && (actions = rhs.getActions()) != null) {
                for (Action action : actions) {
                    ActionValue actionValue;
                    if (this.rule.getDebug() != null) {
                        action.setDebug(this.rule.getDebug());
                    }
                    if ((actionValue = action.execute(context, this.objectCriteriaMap.keySet(), matchedObjects, this.variableMap)) == null) continue;
                    actionValues.add(actionValue);
                }
            }
        }
        session.fireEvent(new ActivationAfterFiredEventImpl(this, session));
        this.processed = true;
        return this.rule;
    }

    public void setObjectCriteriaMap(Map<Object, List<BaseCriteria>> objectCriteriaMap) {
        this.objectCriteriaMap = objectCriteriaMap;
    }

    @Override
    public boolean contain(Object obj) {
        return this.objectCriteriaMap.containsKey(obj);
    }

    @Override
    public boolean reevaluate(Object obj, EvaluationContext context) {
        ArrayList<Object> allMatchedObjects;
        BaseCriteria criteria;
        EvaluateResponse response;
        Object key = obj;
        if (obj instanceof HashMap && !(obj instanceof GeneralEntity)) {
            key = HashMap.class.getName();
        }
        if (!this.objectCriteriaMap.containsKey(key)) {
            return true;
        }
        List<BaseCriteria> list = this.objectCriteriaMap.get(key);
        boolean result = false;
        Iterator<BaseCriteria> iterator = list.iterator();
        while (iterator.hasNext() && (result = (response = (criteria = iterator.next()).evaluate(context, obj, allMatchedObjects = new ArrayList<Object>())).getResult())) {
            for (Object e : allMatchedObjects) {
                this.addObjectCriteria(e, criteria);
            }
        }
        return result;
    }

    private void addObjectCriteria(Object obj, BaseCriteria criteria) {
        if (obj instanceof HashMap && !(obj instanceof GeneralEntity)) {
            obj = HashMap.class.getName();
        }
        if (this.objectCriteriaMap.containsKey(obj)) {
            List<BaseCriteria> list = this.objectCriteriaMap.get(obj);
            if (!list.contains(criteria)) {
                list.add(criteria);
            }
        } else {
            ArrayList<BaseCriteria> list = new ArrayList<BaseCriteria>();
            list.add(criteria);
            this.objectCriteriaMap.put(obj, list);
        }
    }

    @Override
    public Rule getRule() {
        return this.rule;
    }

    public void setRule(Rule rule) {
        this.rule = rule;
    }

    @Override
    public boolean isProcessed() {
        return this.processed;
    }

    public void setProcessed(boolean processed) {
        this.processed = processed;
    }

    @Override
    public int compareTo(Activation o) {
        Integer o1 = o.getRule().getSalience();
        Integer o2 = this.rule.getSalience();
        if (o1 != null && o2 != null) {
            return o1 - o2;
        }
        if (o1 != null) {
            return 1;
        }
        if (o2 != null) {
            return -1;
        }
        return 0;
    }
}

