/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.runtime.agenda;

import com.bstek.urule.action.ActionValue;
import com.bstek.urule.model.rule.Rule;
import com.bstek.urule.model.rule.RuleInfo;
import com.bstek.urule.runtime.agenda.AbstractRuleBox;
import com.bstek.urule.runtime.agenda.Activation;
import com.bstek.urule.runtime.agenda.ActivationGroup;
import com.bstek.urule.runtime.agenda.AgendaFilter;
import com.bstek.urule.runtime.agenda.RuleBox;
import com.bstek.urule.runtime.rete.Context;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class ActivationGroupRuleBox
extends AbstractRuleBox {
    private Map<String, ActivationGroup> activationGroupMap = new HashMap<String, ActivationGroup>();

    public ActivationGroupRuleBox(Context context, List<RuleInfo> executedRules) {
        super(context, executedRules);
    }

    @Override
    public List<RuleInfo> execute(AgendaFilter filter, int max, List<ActionValue> actionValues) {
        ArrayList<RuleInfo> ruleInfos = new ArrayList<RuleInfo>();
        ActivationGroup group = this.findNextActivationGroup();
        while (group != null && ruleInfos.size() < max) {
            List<RuleInfo> ruleInfoResult = group.execute(this.context, filter, 1, actionValues);
            if (ruleInfoResult != null) {
                ruleInfos.addAll(ruleInfoResult);
            }
            if (ruleInfos.size() >= max) break;
            group = this.findNextActivationGroup();
        }
        return ruleInfos;
    }

    public ActivationGroup findNextActivationGroup() {
        for (ActivationGroup group : this.activationGroupMap.values()) {
            if (group.isExecuted()) continue;
            return group;
        }
        return null;
    }

    @Override
    public RuleBox next() {
        ActivationGroup group = this.findNextActivationGroup();
        if (group != null) {
            return this;
        }
        return null;
    }

    @Override
    public void clean() {
        this.executedRules.clear();
        this.activationGroupMap.clear();
        this.rules.clear();
    }

    @Override
    public void retract(Object obj) {
        for (ActivationGroup group : this.activationGroupMap.values()) {
            List<Activation> activations = group.getActivations();
            super.retract(obj, activations);
        }
    }

    @Override
    public boolean add(Activation activation) {
        boolean shouldAdd = this.activationShouldAdd(activation);
        if (!shouldAdd) {
            return false;
        }
        Rule rule = activation.getRule();
        String activationGroup = rule.getActivationGroup();
        if (StringUtils.isEmpty((String)activationGroup)) {
            return false;
        }
        ActivationGroup group = this.activationGroupMap.get(activationGroup);
        if (group == null) {
            group = new ActivationGroup(activationGroup, this.executedRules);
            this.activationGroupMap.put(activationGroup, group);
        }
        List<Activation> list = group.getActivations();
        this.addActivation(activation, list);
        this.rules.add(activation.getRule());
        return true;
    }
}

