/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.runtime.agenda;

import com.bstek.urule.model.rule.Rule;
import com.bstek.urule.model.rule.RuleInfo;
import com.bstek.urule.runtime.KnowledgeSession;
import com.bstek.urule.runtime.agenda.Activation;
import com.bstek.urule.runtime.agenda.RuleBox;
import com.bstek.urule.runtime.event.impl.ActivationCancelledEventImpl;
import com.bstek.urule.runtime.rete.Context;
import com.bstek.urule.runtime.rete.EvaluationContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractRuleBox
implements RuleBox {
    protected List<RuleInfo> executedRules;
    protected Context context;
    protected List<Rule> rules;

    public AbstractRuleBox(Context context, List<RuleInfo> executedRules) {
        this.context = context;
        this.rules = new ArrayList<Rule>();
        this.executedRules = executedRules;
    }

    protected void retract(Object obj, List<Activation> activations) {
        ArrayList<Activation> needRemovedList = new ArrayList<Activation>();
        for (Activation activation : activations) {
            if (!activation.contain(obj)) continue;
            needRemovedList.add(activation);
        }
        KnowledgeSession session = (KnowledgeSession)this.context.getWorkingMemory();
        for (Activation ac : needRemovedList) {
            activations.remove(ac);
            session.fireEvent(new ActivationCancelledEventImpl(ac, session));
        }
    }

    protected boolean addActivation(Activation activation, List<Activation> list) {
        boolean result = list.add(activation);
        Collections.sort(list);
        return result;
    }

    protected boolean activationShouldAdd(Activation activation) {
        Rule rule = activation.getRule();
        for (Rule r : this.rules) {
            if (!r.equals(rule)) continue;
            return r.getLoop() != null && r.getLoop() != false;
        }
        return true;
    }

    @Override
    public List<Rule> getRules() {
        return this.rules;
    }

    protected List<Activation> reevaluate(Object obj, List<Activation> activations, EvaluationContext context) {
        ArrayList<Activation> needRemoved = new ArrayList<Activation>();
        for (Activation activation : activations) {
            if (activation.isProcessed() || activation.reevaluate(obj, context)) continue;
            needRemoved.add(activation);
        }
        KnowledgeSession session = (KnowledgeSession)context.getWorkingMemory();
        for (Activation ac : needRemoved) {
            activations.remove(ac);
            session.fireEvent(new ActivationCancelledEventImpl(ac, session));
        }
        return needRemoved;
    }
}

