/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.runtime;

import com.bstek.urule.RuleException;
import com.bstek.urule.Utils;
import com.bstek.urule.debug.DebugWriter;
import com.bstek.urule.debug.MessageItem;
import com.bstek.urule.model.GeneralEntity;
import com.bstek.urule.model.flow.FlowDefinition;
import com.bstek.urule.model.flow.ins.FlowContextImpl;
import com.bstek.urule.model.flow.ins.ProcessInstance;
import com.bstek.urule.model.library.Datatype;
import com.bstek.urule.model.rule.Rule;
import com.bstek.urule.runtime.KnowledgePackage;
import com.bstek.urule.runtime.KnowledgePackageImpl;
import com.bstek.urule.runtime.KnowledgeSession;
import com.bstek.urule.runtime.WorkingMemory;
import com.bstek.urule.runtime.agenda.ActivationImpl;
import com.bstek.urule.runtime.agenda.Agenda;
import com.bstek.urule.runtime.agenda.AgendaFilter;
import com.bstek.urule.runtime.agenda.RuleBox;
import com.bstek.urule.runtime.event.ActivationAfterFiredEvent;
import com.bstek.urule.runtime.event.ActivationBeforeFiredEvent;
import com.bstek.urule.runtime.event.ActivationCancelledEvent;
import com.bstek.urule.runtime.event.ActivationCreatedEvent;
import com.bstek.urule.runtime.event.ActivationEvent;
import com.bstek.urule.runtime.event.AgendaEventListener;
import com.bstek.urule.runtime.event.KnowledgeEvent;
import com.bstek.urule.runtime.event.KnowledgeEventListener;
import com.bstek.urule.runtime.event.ProcessAfterCompletedEvent;
import com.bstek.urule.runtime.event.ProcessAfterNodeTriggeredEvent;
import com.bstek.urule.runtime.event.ProcessAfterStartedEvent;
import com.bstek.urule.runtime.event.ProcessBeforeCompletedEvent;
import com.bstek.urule.runtime.event.ProcessBeforeNodeTriggeredEvent;
import com.bstek.urule.runtime.event.ProcessBeforeStartedEvent;
import com.bstek.urule.runtime.event.ProcessEvent;
import com.bstek.urule.runtime.event.ProcessEventListener;
import com.bstek.urule.runtime.event.impl.ProcessAfterCompletedEventImpl;
import com.bstek.urule.runtime.response.ExecutionResponseImpl;
import com.bstek.urule.runtime.response.FlowExecutionResponse;
import com.bstek.urule.runtime.response.RuleExecutionResponse;
import com.bstek.urule.runtime.rete.Context;
import com.bstek.urule.runtime.rete.ContextImpl;
import com.bstek.urule.runtime.rete.EvaluationContextImpl;
import com.bstek.urule.runtime.rete.FactTracker;
import com.bstek.urule.runtime.rete.ReteInstance;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class KnowledgeSessionImpl
implements KnowledgeSession {
    private Context context;
    private EvaluationContextImpl evaluationContext;
    private FlowContextImpl flowContext;
    private Agenda agenda;
    private List<MessageItem> debugMessageItems = new ArrayList<MessageItem>();
    private Map<String, Object> initParameters = new HashMap<String, Object>();
    private List<Object> facts = new ArrayList<Object>();
    private List<Object> historyFacts = new ArrayList<Object>();
    private List<KnowledgePackage> knowledgePackageList = new ArrayList<KnowledgePackage>();
    private List<ReteInstance> reteInstanceList = new ArrayList<ReteInstance>();
    private Map<String, Object> parameterMap = new HashMap<String, Object>();
    private List<Map<?, ?>> factMaps = new ArrayList();
    private List<KnowledgeEventListener> eventListeners = new ArrayList<KnowledgeEventListener>();

    public KnowledgeSessionImpl(KnowledgePackage knowledgePackage) {
        this(new KnowledgePackage[]{knowledgePackage}, null);
    }

    public KnowledgeSessionImpl(KnowledgePackage knowledgePackage, List<MessageItem> debugMessageItems) {
        this(new KnowledgePackage[]{knowledgePackage}, debugMessageItems);
    }

    public KnowledgeSessionImpl(KnowledgePackage[] knowledgePackages, List<MessageItem> debugMessageItems) {
        if (debugMessageItems != null) {
            this.debugMessageItems = debugMessageItems;
        }
        for (KnowledgePackage knowledgePackage : knowledgePackages) {
            this.knowledgePackageList.add(knowledgePackage);
            this.reteInstanceList.add(knowledgePackage.newReteInstance());
            Map<String, String> p = knowledgePackage.getParameters();
            if (p == null) continue;
            for (String key : p.keySet()) {
                Datatype type = Datatype.valueOf(p.get(key));
                if (type.equals((Object)Datatype.Integer)) {
                    this.initParameters.put(key, 0);
                    continue;
                }
                if (type.equals((Object)Datatype.Long)) {
                    this.initParameters.put(key, 0);
                    continue;
                }
                if (type.equals((Object)Datatype.Double)) {
                    this.initParameters.put(key, 0);
                    continue;
                }
                if (type.equals((Object)Datatype.Float)) {
                    this.initParameters.put(key, 0);
                    continue;
                }
                if (type.equals((Object)Datatype.Boolean)) {
                    this.initParameters.put(key, false);
                    continue;
                }
                if (type.equals((Object)Datatype.List)) {
                    this.initParameters.put(key, new ArrayList());
                    continue;
                }
                if (type.equals((Object)Datatype.Set)) {
                    this.initParameters.put(key, new HashSet());
                    continue;
                }
                if (!type.equals((Object)Datatype.Map)) continue;
                this.initParameters.put(key, new HashMap());
            }
        }
        this.initContext();
        this.agenda = new Agenda(this, this.context);
    }

    @Override
    public RuleExecutionResponse fireRules() {
        return this.execute(null, null, Integer.MAX_VALUE);
    }

    @Override
    public RuleExecutionResponse fireRules(int max) {
        return this.execute(null, null, max);
    }

    @Override
    public RuleExecutionResponse fireRules(AgendaFilter filter) {
        return this.execute(filter, null, Integer.MAX_VALUE);
    }

    @Override
    public RuleExecutionResponse fireRules(AgendaFilter filter, int max) {
        return this.execute(filter, null, max);
    }

    @Override
    public RuleExecutionResponse fireRules(Map<String, Object> parameters) {
        return this.execute(null, parameters, Integer.MAX_VALUE);
    }

    @Override
    public RuleExecutionResponse fireRules(Map<String, Object> parameters, AgendaFilter filter) {
        return this.execute(filter, parameters, Integer.MAX_VALUE);
    }

    @Override
    public RuleExecutionResponse fireRules(Map<String, Object> parameters, AgendaFilter filter, int max) {
        return this.execute(filter, parameters, max);
    }

    @Override
    public RuleExecutionResponse fireRules(Map<String, Object> parameters, int max) {
        return this.execute(null, parameters, max);
    }

    @Override
    public FlowExecutionResponse startProcess(String processId) {
        return this.startProcess(processId, null);
    }

    @Override
    public FlowExecutionResponse startProcess(String processId, Map<String, Object> parameters) {
        FlowDefinition targetFlow = null;
        for (KnowledgePackage knowledgePackage : this.knowledgePackageList) {
            Map<String, FlowDefinition> flowMap = knowledgePackage.getFlowMap();
            if (flowMap == null || !flowMap.containsKey(processId)) continue;
            targetFlow = flowMap.get(processId);
            break;
        }
        if (targetFlow == null) {
            throw new RuleException("Rule flow [" + processId + "] not exist.");
        }
        this.parameterMap.clear();
        this.clearInitParameters();
        this.parameterMap.putAll(this.initParameters);
        if (parameters != null) {
            this.parameterMap.putAll(parameters);
        }
        this.flowContext.setVariableMap(this.parameterMap);
        this.flowContext.setResponse(new ExecutionResponseImpl());
        long start = System.currentTimeMillis();
        ProcessInstance pi = targetFlow.newInstance(this.flowContext);
        this.fireEvent(new ProcessAfterCompletedEventImpl(pi, this));
        this.historyFacts.addAll(this.facts);
        this.facts.clear();
        ExecutionResponseImpl response = (ExecutionResponseImpl)this.flowContext.getResponse();
        response.setDuration(System.currentTimeMillis() - start);
        this.reset();
        return response;
    }

    private RuleExecutionResponse execute(AgendaFilter filter, Map<String, Object> params, int max) {
        this.parameterMap.clear();
        this.clearInitParameters();
        this.parameterMap.putAll(this.initParameters);
        for (Map<?, ?> map : this.factMaps) {
            for (Object key : map.keySet()) {
                this.parameterMap.put(key.toString(), map.get(key));
            }
        }
        if (params != null) {
            this.parameterMap.putAll(params);
        }
        if (!this.facts.contains(this.parameterMap)) {
            this.facts.add(this.parameterMap);
        }
        long start = System.currentTimeMillis();
        for (Object fact : this.facts) {
            this.evaluationRete(fact);
        }
        this.evaluationContext.clean();
        this.buildElseRules(true);
        ExecutionResponseImpl resp = (ExecutionResponseImpl)this.agenda.execute(filter, max);
        resp.setDuration(System.currentTimeMillis() - start);
        this.reset();
        return resp;
    }

    private void clearInitParameters() {
        ArrayList<String> stringList = new ArrayList<String>();
        for (String key : this.initParameters.keySet()) {
            Object obj = this.initParameters.get(key);
            if (obj == null) continue;
            if (obj instanceof List) {
                ((List)obj).clear();
                continue;
            }
            if (obj instanceof Set) {
                ((Set)obj).clear();
                continue;
            }
            if (obj instanceof Map) {
                ((Map)obj).clear();
                continue;
            }
            if (obj instanceof Number) {
                this.initParameters.put(key, 0);
                continue;
            }
            if (obj instanceof Boolean) {
                this.initParameters.put(key, false);
                continue;
            }
            if (!(obj instanceof String)) continue;
            stringList.add(key);
        }
        for (String key : stringList) {
            this.initParameters.remove(key);
        }
    }

    private void buildElseRules(boolean buildNoLhsRules) {
        ArrayList<FactTracker> trackers = new ArrayList<FactTracker>();
        for (KnowledgePackage knowledgePackage : this.knowledgePackageList) {
            List<Rule> noLhsRules;
            if (buildNoLhsRules && (noLhsRules = knowledgePackage.getNoLhsRules()) != null) {
                for (Rule rule : noLhsRules) {
                    FactTracker tracker = new FactTracker();
                    tracker.setActivation(new ActivationImpl(rule, null));
                    trackers.add(tracker);
                }
            }
            this.buildWithElseRules(trackers, knowledgePackage);
        }
        if (trackers.size() > 0) {
            this.agenda.addTrackers(trackers);
        }
    }

    private void buildWithElseRules(List<FactTracker> trackers, KnowledgePackage knowledgePackage) {
        List<Rule> withElseRules = knowledgePackage.getWithElseRules();
        if (withElseRules == null) {
            return;
        }
        for (Rule rule : withElseRules) {
            boolean active = false;
            for (RuleBox box : this.agenda.getRuleBoxes()) {
                if (box.getRules().contains(rule)) {
                    active = true;
                    break;
                }
                if (!active) continue;
                break;
            }
            if (active) continue;
            Rule elseRule = ((KnowledgePackageImpl)knowledgePackage).getElseRule(rule);
            FactTracker tracker = new FactTracker();
            tracker.setActivation(new ActivationImpl(elseRule, null));
            trackers.add(tracker);
        }
    }

    @Override
    public Object getParameter(String key) {
        return this.parameterMap.get(key);
    }

    @Override
    public boolean update(Object obj) {
        this.reevaluate(obj);
        return true;
    }

    @Override
    public boolean insert(Object fact) {
        if (!(fact instanceof GeneralEntity) && fact instanceof Map) {
            Map map = (Map)fact;
            this.factMaps.add(map);
        } else if (!this.facts.contains(fact)) {
            return this.facts.add(fact);
        }
        return false;
    }

    @Override
    public boolean retract(Object fact) {
        this.agenda.retract(fact);
        this.facts.remove(fact);
        this.historyFacts.remove(fact);
        return true;
    }

    @Override
    public void assertFact(Object fact) {
        this.facts.add(fact);
        this.reevaluate(fact);
    }

    @Override
    public Map<String, Object> getParameters() {
        return this.parameterMap;
    }

    @Override
    public List<Object> getHistoryFacts() {
        return this.historyFacts;
    }

    private void reset() {
        this.historyFacts.clear();
        this.agenda.clean();
        this.factMaps.clear();
        this.facts.clear();
    }

    private void reevaluate(Object obj) {
        for (ReteInstance reteInstance : this.reteInstanceList) {
            reteInstance.resetForReevaluate(obj);
        }
        this.evaluationRete(obj);
        this.buildElseRules(false);
        this.evaluationContext.clean();
    }

    private void evaluationRete(Object fact) {
        for (ReteInstance reteInstance : this.reteInstanceList) {
            Collection<FactTracker> trackers = reteInstance.enter(this.evaluationContext, fact);
            if (trackers == null) continue;
            this.agenda.addTrackers(trackers);
        }
    }

    @Override
    public void writeLogFile() throws IOException {
        if (this.debugMessageItems.size() == 0) {
            return;
        }
        for (DebugWriter writer : Utils.getDebugWriters()) {
            writer.write(this.debugMessageItems);
        }
        this.debugMessageItems.clear();
    }

    @Override
    public List<Object> getAllFacts() {
        return this.facts;
    }

    @Override
    public void addEventListener(KnowledgeEventListener listener) {
        this.eventListeners.add(listener);
    }

    @Override
    public List<KnowledgeEventListener> getKnowledgeEventListeners() {
        return this.eventListeners;
    }

    @Override
    public boolean removeEventListener(KnowledgeEventListener listener) {
        return this.eventListeners.remove(listener);
    }

    @Override
    public void fireEvent(KnowledgeEvent event) {
        block11: {
            block10: {
                if (!(event instanceof ActivationEvent)) break block10;
                for (KnowledgeEventListener listener : this.eventListeners) {
                    ActivationEvent e;
                    if (!(listener instanceof AgendaEventListener)) continue;
                    AgendaEventListener lis = (AgendaEventListener)listener;
                    if (event instanceof ActivationCancelledEvent) {
                        e = (ActivationCancelledEvent)event;
                        lis.activationCancelled((ActivationCancelledEvent)e);
                        continue;
                    }
                    if (event instanceof ActivationCreatedEvent) {
                        e = (ActivationCreatedEvent)event;
                        lis.activationCreated((ActivationCreatedEvent)e);
                        continue;
                    }
                    if (event instanceof ActivationBeforeFiredEvent) {
                        e = (ActivationBeforeFiredEvent)event;
                        lis.beforeActivationFired((ActivationBeforeFiredEvent)e);
                        continue;
                    }
                    if (!(event instanceof ActivationAfterFiredEvent)) continue;
                    e = (ActivationAfterFiredEvent)event;
                    lis.afterActivationFired((ActivationAfterFiredEvent)e);
                }
                break block11;
            }
            if (!(event instanceof ProcessEvent)) break block11;
            for (KnowledgeEventListener listener : this.eventListeners) {
                ProcessEvent e;
                if (!(listener instanceof ProcessEventListener)) continue;
                ProcessEventListener lis = (ProcessEventListener)listener;
                if (event instanceof ProcessAfterCompletedEvent) {
                    e = (ProcessAfterCompletedEvent)event;
                    lis.afterProcessCompleted((ProcessAfterCompletedEvent)e);
                    continue;
                }
                if (event instanceof ProcessAfterStartedEvent) {
                    e = (ProcessAfterStartedEvent)event;
                    lis.afterProcessStarted((ProcessAfterStartedEvent)e);
                    continue;
                }
                if (event instanceof ProcessBeforeCompletedEvent) {
                    e = (ProcessBeforeCompletedEvent)event;
                    lis.beforeProcessCompleted((ProcessBeforeCompletedEvent)e);
                    continue;
                }
                if (event instanceof ProcessBeforeStartedEvent) {
                    e = (ProcessBeforeStartedEvent)event;
                    lis.beforeProcessStarted((ProcessBeforeStartedEvent)e);
                    continue;
                }
                if (event instanceof ProcessAfterNodeTriggeredEvent) {
                    e = (ProcessAfterNodeTriggeredEvent)event;
                    lis.afterNodeTriggered((ProcessAfterNodeTriggeredEvent)e);
                    continue;
                }
                if (!(event instanceof ProcessBeforeNodeTriggeredEvent)) continue;
                e = (ProcessBeforeNodeTriggeredEvent)event;
                lis.beforeNodeTriggered((ProcessBeforeNodeTriggeredEvent)e);
            }
        }
    }

    private void initContext() {
        Map<String, String> allVariableCateogoryMap = null;
        for (KnowledgePackage knowledgePackage : this.knowledgePackageList) {
            if (allVariableCateogoryMap == null) {
                allVariableCateogoryMap = knowledgePackage.getVariableCateogoryMap();
                continue;
            }
            allVariableCateogoryMap.putAll(knowledgePackage.getVariableCateogoryMap());
        }
        this.context = new ContextImpl(this, Utils.getApplicationContext(), allVariableCateogoryMap, this.debugMessageItems);
        this.evaluationContext = new EvaluationContextImpl(this, Utils.getApplicationContext(), allVariableCateogoryMap, this.debugMessageItems);
        this.flowContext = new FlowContextImpl((WorkingMemory)this, allVariableCateogoryMap, Utils.getApplicationContext(), this.debugMessageItems);
    }

    public List<ReteInstance> getReteInstanceList() {
        return this.reteInstanceList;
    }
}

