/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.runtime;

import com.bstek.urule.RuleException;
import com.bstek.urule.model.flow.FlowDefinition;
import com.bstek.urule.model.rete.BaseReteNode;
import com.bstek.urule.model.rete.Line;
import com.bstek.urule.model.rete.ObjectTypeNode;
import com.bstek.urule.model.rete.Rete;
import com.bstek.urule.model.rete.ReteNode;
import com.bstek.urule.model.rete.ReteNodeJsonDeserializer;
import com.bstek.urule.runtime.KnowledgePackage;
import com.bstek.urule.runtime.KnowledgePackageImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.map.annotate.JsonDeserialize;

public class KnowledgePackageWrapper {
    @JsonDeserialize(as=KnowledgePackageImpl.class)
    private KnowledgePackage knowledgePackage;
    @JsonDeserialize(using=ReteNodeJsonDeserializer.class)
    private List<ReteNode> allNodes = new ArrayList<ReteNode>();

    public KnowledgePackageWrapper() {
    }

    public KnowledgePackageWrapper(KnowledgePackage knowledgePackage) {
        this.knowledgePackage = knowledgePackage;
        this.initNodes();
    }

    private void initNodes() {
        Rete rete = this.knowledgePackage.getRete();
        List<ObjectTypeNode> typeNodes = rete.getObjectTypeNodes();
        ArrayList<ReteNode> childreNodes = new ArrayList<ReteNode>();
        childreNodes.addAll(typeNodes);
        this.queryReteNodes(childreNodes);
    }

    private void queryReteNodes(List<ReteNode> reteNodes) {
        if (reteNodes == null) {
            return;
        }
        for (ReteNode reteNode : reteNodes) {
            if (!this.allNodes.contains(reteNode) && !(reteNode instanceof ObjectTypeNode)) {
                this.allNodes.add(reteNode);
            }
            if (!(reteNode instanceof BaseReteNode)) continue;
            BaseReteNode abstractReteNode = (BaseReteNode)reteNode;
            this.queryReteNodes(abstractReteNode.getChildrenNodes());
        }
    }

    public void buildDeserialize() {
        Rete rete = this.knowledgePackage.getRete();
        List<ObjectTypeNode> typeNodes = rete.getObjectTypeNodes();
        for (ObjectTypeNode typeNode : typeNodes) {
            List<Line> lines = typeNode.getLines();
            for (Line line : lines) {
                line.setFrom(typeNode);
            }
            this.rebuildLine(lines, this.allNodes);
        }
        ((KnowledgePackageImpl)this.knowledgePackage).buildWithElseRules();
        Map<String, FlowDefinition> flowMap = this.knowledgePackage.getFlowMap();
        if (flowMap != null && flowMap.size() > 0) {
            for (FlowDefinition fd : flowMap.values()) {
                fd.buildConnectionToNode();
            }
        }
    }

    private void rebuildLine(List<Line> lines, List<ReteNode> reteNodes) {
        if (lines == null) {
            return;
        }
        for (Line line : lines) {
            BaseReteNode node;
            if (line.getFrom() == null) {
                int fromId = line.getFromNodeId();
                ReteNode fromNode = this.findTargetNode(reteNodes, fromId);
                line.setFrom(fromNode);
                if (fromNode instanceof BaseReteNode) {
                    node = (BaseReteNode)fromNode;
                    this.rebuildLine(node.getLines(), reteNodes);
                }
            }
            if (line.getTo() != null) continue;
            int toId = line.getToNodeId();
            ReteNode toNode = this.findTargetNode(reteNodes, toId);
            line.setTo(toNode);
            if (!(toNode instanceof BaseReteNode)) continue;
            node = (BaseReteNode)toNode;
            this.rebuildLine(node.getLines(), reteNodes);
        }
    }

    private ReteNode findTargetNode(List<ReteNode> reteNodes, int id) {
        for (ReteNode node : reteNodes) {
            if (node.getId() != id) continue;
            return node;
        }
        throw new RuleException("Node[" + id + "] not exist.");
    }

    public List<ReteNode> getAllNodes() {
        return this.allNodes;
    }

    public KnowledgePackage getKnowledgePackage() {
        return this.knowledgePackage;
    }
}

