/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.runtime;

import com.bstek.urule.model.Node;
import com.bstek.urule.model.RuleJsonDeserializer;
import com.bstek.urule.model.flow.FlowDefinition;
import com.bstek.urule.model.rete.BaseReteNode;
import com.bstek.urule.model.rete.Line;
import com.bstek.urule.model.rete.ObjectTypeNode;
import com.bstek.urule.model.rete.Rete;
import com.bstek.urule.model.rete.TerminalNode;
import com.bstek.urule.model.rule.Other;
import com.bstek.urule.model.rule.Rhs;
import com.bstek.urule.model.rule.Rule;
import com.bstek.urule.runtime.KnowledgePackage;
import com.bstek.urule.runtime.rete.ReteInstance;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonDeserialize;

public class KnowledgePackageImpl
implements KnowledgePackage {
    private Rete rete;
    private Map<String, String> variableCategoryMap = new HashMap<String, String>();
    private Map<String, FlowDefinition> flowMap;
    private Map<String, String> parameters;
    @JsonDeserialize(using=RuleJsonDeserializer.class)
    private List<Rule> noLhsRules;
    @JsonIgnore
    private Map<Rule, Rule> elseRulesMap = new HashMap<Rule, Rule>();
    @JsonIgnore
    private List<Rule> withElseRules = new ArrayList<Rule>();
    private long timestamp;
    private String id = UUID.randomUUID().toString();

    public KnowledgePackageImpl() {
        this.timestamp = System.currentTimeMillis();
    }

    public void buildWithElseRules() {
        List<ObjectTypeNode> typeNodes = this.rete.getObjectTypeNodes();
        if (typeNodes != null) {
            for (ObjectTypeNode typeNode : typeNodes) {
                this.buildReteLinesForElseRules(typeNode.getLines());
            }
        }
    }

    private void buildReteLinesForElseRules(List<Line> lines) {
        if (lines == null) {
            return;
        }
        for (Line line : lines) {
            Node toNode = line.getTo();
            if (toNode == null) continue;
            if (toNode instanceof TerminalNode) {
                Other other;
                TerminalNode terminalNode = (TerminalNode)toNode;
                Rule rule = terminalNode.getRule();
                if (this.withElseRules.contains(rule) || (other = rule.getOther()) == null || other.getActions() == null || other.getActions().size() <= 0) continue;
                this.withElseRules.add(rule);
                Rule elseRule = new Rule();
                elseRule.setName(rule.getName() + "else");
                elseRule.setActivationGroup(rule.getActivationGroup());
                elseRule.setAgendaGroup(rule.getAgendaGroup());
                elseRule.setAutoFocus(rule.getAutoFocus());
                elseRule.setEffectiveDate(rule.getEffectiveDate());
                elseRule.setExpiresDate(rule.getExpiresDate());
                elseRule.setEnabled(rule.getEnabled());
                elseRule.setRuleflowGroup(rule.getRuleflowGroup());
                elseRule.setSalience(rule.getSalience());
                Rhs rhs = new Rhs();
                rhs.setActions(other.getActions());
                elseRule.setRhs(rhs);
                this.elseRulesMap.put(rule, elseRule);
                continue;
            }
            if (!(toNode instanceof BaseReteNode)) continue;
            BaseReteNode reteNode = (BaseReteNode)toNode;
            this.buildReteLinesForElseRules(reteNode.getLines());
        }
    }

    public Rule getElseRule(Rule rule) {
        return this.elseRulesMap.get(rule);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Rete getRete() {
        return this.rete;
    }

    public void setRete(Rete rete) {
        this.rete = rete;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public void resetTimestamp() {
        this.timestamp = System.currentTimeMillis();
    }

    @Override
    public Map<String, String> getVariableCateogoryMap() {
        return this.variableCategoryMap;
    }

    public void setNoLhsRules(List<Rule> noLhsRules) {
        this.noLhsRules = noLhsRules;
    }

    @Override
    public List<Rule> getNoLhsRules() {
        return this.noLhsRules;
    }

    @Override
    public List<Rule> getWithElseRules() {
        return this.withElseRules;
    }

    public void setVariableCategoryMap(Map<String, String> variableCategoryMap) {
        this.variableCategoryMap = variableCategoryMap;
    }

    @Override
    public Map<String, FlowDefinition> getFlowMap() {
        return this.flowMap;
    }

    public void setFlowMap(Map<String, FlowDefinition> flowMap) {
        this.flowMap = flowMap;
    }

    @Override
    public ReteInstance newReteInstance() {
        return this.rete.newReteInstance();
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    @Override
    public Map<String, String> getParameters() {
        return this.parameters;
    }
}

