/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.runtime;

import com.bstek.urule.model.library.Datatype;
import com.bstek.urule.model.library.action.Method;
import com.bstek.urule.model.library.action.Parameter;
import com.bstek.urule.model.library.action.SpringBean;
import com.bstek.urule.model.library.action.annotation.ActionBean;
import com.bstek.urule.model.library.action.annotation.ActionMethod;
import com.bstek.urule.model.library.action.annotation.ActionMethodParameter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class BuiltInActionLibraryBuilder
implements ApplicationContextAware {
    private List<SpringBean> builtInActions = new ArrayList<SpringBean>();

    public List<SpringBean> getBuiltInActions() {
        return this.builtInActions;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        System.out.println("Load built in actions...");
        String[] names = applicationContext.getBeanDefinitionNames();
        if (names == null || names.length == 0) {
            return;
        }
        for (String name : names) {
            ActionBean aa;
            Object obj = null;
            try {
                obj = applicationContext.getBean(name);
            }
            catch (Exception ex) {
                continue;
            }
            if (obj == null || (aa = obj.getClass().getAnnotation(ActionBean.class)) == null) continue;
            SpringBean bean = new SpringBean();
            bean.setId(name);
            bean.setName(aa.name());
            bean.setMethods(this.buildMethod(obj.getClass().getMethods()));
            this.builtInActions.add(bean);
        }
    }

    private List<Method> buildMethod(java.lang.reflect.Method[] methods) {
        ArrayList<Method> list = new ArrayList<Method>();
        for (java.lang.reflect.Method m : methods) {
            ActionMethod methodAnnotation = m.getAnnotation(ActionMethod.class);
            if (methodAnnotation == null) continue;
            String name = methodAnnotation.name();
            String methodName = m.getName();
            Method libMethod = new Method();
            libMethod.setMethodName(methodName);
            libMethod.setName(name);
            list.add(libMethod);
            ActionMethodParameter mp = m.getAnnotation(ActionMethodParameter.class);
            ArrayList<String> parameterNames = new ArrayList<String>();
            if (mp != null) {
                String[] pnames;
                for (String pname : pnames = mp.names()) {
                    parameterNames.add(pname);
                }
            }
            libMethod.setParameters(this.buildParameters(m, parameterNames));
        }
        return list;
    }

    private List<Parameter> buildParameters(java.lang.reflect.Method m, List<String> parameterNames) {
        ArrayList<Parameter> list = new ArrayList<Parameter>();
        Class<?>[] pclasses = m.getParameterTypes();
        for (int i = 0; i < pclasses.length; ++i) {
            Class<?> c = pclasses[i];
            String name = "";
            if (parameterNames.size() > i) {
                name = parameterNames.get(i);
            }
            Parameter p = new Parameter();
            p.setName(name);
            p.setType(this.buildDatatype(c));
            list.add(p);
        }
        return list;
    }

    private Datatype buildDatatype(Class<?> clazz) {
        if (clazz.getName().equals("java.lang.Object")) {
            return Datatype.Object;
        }
        if (clazz.isAssignableFrom(Integer.class) || clazz.isAssignableFrom(Integer.TYPE)) {
            return Datatype.Integer;
        }
        if (clazz.isAssignableFrom(Long.class) || clazz.isAssignableFrom(Long.TYPE)) {
            return Datatype.Long;
        }
        if (clazz.isAssignableFrom(Double.class) || clazz.isAssignableFrom(Double.TYPE)) {
            return Datatype.Double;
        }
        if (clazz.isAssignableFrom(Float.class) || clazz.isAssignableFrom(Float.TYPE)) {
            return Datatype.Float;
        }
        if (clazz.isAssignableFrom(BigDecimal.class)) {
            return Datatype.BigDecimal;
        }
        if (clazz.isAssignableFrom(Boolean.class) || clazz.isAssignableFrom(Boolean.TYPE)) {
            return Datatype.Boolean;
        }
        if (clazz.isAssignableFrom(Date.class)) {
            return Datatype.Date;
        }
        if (clazz.isAssignableFrom(List.class)) {
            return Datatype.List;
        }
        if (clazz.isAssignableFrom(Set.class)) {
            return Datatype.Set;
        }
        if (clazz.isAssignableFrom(Enum.class)) {
            return Datatype.Enum;
        }
        if (clazz.isAssignableFrom(Map.class)) {
            return Datatype.Map;
        }
        if (clazz.isAssignableFrom(String.class)) {
            return Datatype.String;
        }
        if (clazz.isAssignableFrom(Character.class) || clazz.isAssignableFrom(Character.TYPE)) {
            return Datatype.Char;
        }
        return Datatype.Object;
    }
}

