/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.runtime;

import com.bstek.urule.RuleException;
import com.bstek.urule.runtime.BatchSession;
import com.bstek.urule.runtime.BatchThread;
import com.bstek.urule.runtime.Business;
import com.bstek.urule.runtime.KnowledgePackage;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class BatchSessionImpl
implements BatchSession {
    private ExecutorService executorService;
    private int batchSize;
    private List<Business> businessList = new ArrayList<Business>();
    private KnowledgePackage knowledgePackage;
    private KnowledgePackage[] knowledgePackages;

    public BatchSessionImpl(KnowledgePackage knowledgePackage, int threadSize, int batchSize) {
        this.executorService = Executors.newFixedThreadPool(threadSize);
        this.knowledgePackage = knowledgePackage;
        this.batchSize = batchSize;
    }

    public BatchSessionImpl(KnowledgePackage[] knowledgePackages, int threadSize, int batchSize) {
        this.executorService = Executors.newFixedThreadPool(threadSize);
        this.knowledgePackages = knowledgePackages;
        this.batchSize = batchSize;
    }

    @Override
    public void addBusiness(Business business) {
        if (this.businessList != null) {
            if (this.businessList.size() >= this.batchSize) {
                this.doBusinesses();
                this.businessList = new ArrayList<Business>();
            }
        } else {
            this.businessList = new ArrayList<Business>();
        }
        this.businessList.add(business);
    }

    private void doBusinesses() {
        BatchThread thread = null;
        if (this.knowledgePackage != null) {
            thread = new BatchThread(this.knowledgePackage, this.businessList);
        } else if (this.knowledgePackages != null) {
            thread = new BatchThread(this.knowledgePackages, this.businessList);
        } else {
            throw new RuleException("KnowledgePackage can not be null.");
        }
        this.executorService.execute(thread);
        this.businessList = null;
    }

    @Override
    public void waitForCompletion() {
        if (this.businessList != null && this.businessList.size() > 0) {
            this.doBusinesses();
        }
        this.executorService.shutdown();
        try {
            while (!this.executorService.awaitTermination(300L, TimeUnit.MILLISECONDS)) {
            }
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
            throw new RuleException(ex);
        }
    }
}

