/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.parse.table;

import com.bstek.urule.model.rule.Library;
import com.bstek.urule.model.rule.LibraryType;
import com.bstek.urule.model.table.ScriptDecisionTable;
import com.bstek.urule.parse.Parser;
import com.bstek.urule.parse.table.ColumnParser;
import com.bstek.urule.parse.table.RowParser;
import com.bstek.urule.parse.table.ScriptCellParser;
import org.dom4j.Element;

public class ScriptDecisionTableParser
implements Parser<ScriptDecisionTable> {
    private RowParser rowParser;
    private ColumnParser columnParser;
    private ScriptCellParser scriptCellParser;

    @Override
    public ScriptDecisionTable parse(Element element) {
        ScriptDecisionTable table = new ScriptDecisionTable();
        for (Object obj : element.elements()) {
            if (obj == null || !(obj instanceof Element)) continue;
            Element ele = (Element)obj;
            String name = ele.getName();
            if (this.rowParser.support(name)) {
                table.addRow(this.rowParser.parse(ele));
            } else if (this.columnParser.support(name)) {
                table.addColumn(this.columnParser.parse(ele));
            } else if (this.scriptCellParser.support(name)) {
                table.addCell(this.scriptCellParser.parse(ele));
            }
            if (name.equals("import-variable-library")) {
                table.addLibrary(new Library(ele.attributeValue("path"), null, LibraryType.Variable));
                continue;
            }
            if (name.equals("import-constant-library")) {
                table.addLibrary(new Library(ele.attributeValue("path"), null, LibraryType.Constant));
                continue;
            }
            if (name.equals("import-action-library")) {
                table.addLibrary(new Library(ele.attributeValue("path"), null, LibraryType.Action));
                continue;
            }
            if (!name.equals("import-parameter-library")) continue;
            table.addLibrary(new Library(ele.attributeValue("path"), null, LibraryType.Parameter));
        }
        return table;
    }

    @Override
    public boolean support(String name) {
        return name.equals("script-decision-table");
    }

    public void setColumnParser(ColumnParser columnParser) {
        this.columnParser = columnParser;
    }

    public void setRowParser(RowParser rowParser) {
        this.rowParser = rowParser;
    }

    public void setScriptCellParser(ScriptCellParser scriptCellParser) {
        this.scriptCellParser = scriptCellParser;
    }
}

