/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.parse.table;

import com.bstek.urule.Configure;
import com.bstek.urule.RuleException;
import com.bstek.urule.builder.RulesRebuilder;
import com.bstek.urule.model.library.ResourceLibrary;
import com.bstek.urule.model.library.variable.Variable;
import com.bstek.urule.model.rule.Library;
import com.bstek.urule.model.rule.LibraryType;
import com.bstek.urule.model.rule.Value;
import com.bstek.urule.model.table.Cell;
import com.bstek.urule.model.table.Column;
import com.bstek.urule.model.table.Condition;
import com.bstek.urule.model.table.DecisionTable;
import com.bstek.urule.parse.Parser;
import com.bstek.urule.parse.table.CellParser;
import com.bstek.urule.parse.table.ColumnParser;
import com.bstek.urule.parse.table.RowParser;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;

public class DecisionTableParser
implements Parser<DecisionTable> {
    private RowParser rowParser;
    private ColumnParser columnParser;
    private CellParser cellParser;
    private RulesRebuilder rulesRebuilder;

    @Override
    public DecisionTable parse(Element element) {
        String debug;
        String enabled;
        String expiresDate;
        DecisionTable table = new DecisionTable();
        String salience = element.attributeValue("salience");
        if (StringUtils.isNotEmpty((String)salience)) {
            table.setSalience(Integer.valueOf(salience));
        }
        String effectiveDate = element.attributeValue("effective-date");
        SimpleDateFormat sd = new SimpleDateFormat(Configure.getDateFormat());
        if (StringUtils.isNotEmpty((String)effectiveDate)) {
            try {
                table.setEffectiveDate(sd.parse(effectiveDate));
            }
            catch (ParseException e) {
                throw new RuleException(e);
            }
        }
        if (StringUtils.isNotEmpty((String)(expiresDate = element.attributeValue("expires-date")))) {
            try {
                table.setExpiresDate(sd.parse(expiresDate));
            }
            catch (ParseException e) {
                throw new RuleException(e);
            }
        }
        if (StringUtils.isNotEmpty((String)(enabled = element.attributeValue("enabled")))) {
            table.setEnabled(Boolean.valueOf(enabled));
        }
        if (StringUtils.isNotEmpty((String)(debug = element.attributeValue("debug")))) {
            table.setDebug(Boolean.valueOf(debug));
        }
        for (Object obj : element.elements()) {
            if (obj == null || !(obj instanceof Element)) continue;
            Element ele = (Element)obj;
            String name = ele.getName();
            if (this.rowParser.support(name)) {
                table.addRow(this.rowParser.parse(ele));
            } else if (this.columnParser.support(name)) {
                table.addColumn(this.columnParser.parse(ele));
            } else if (this.cellParser.support(name)) {
                table.addCell(this.cellParser.parse(ele));
            }
            if (name.equals("import-variable-library")) {
                table.addLibrary(new Library(ele.attributeValue("path"), null, LibraryType.Variable));
                continue;
            }
            if (name.equals("import-constant-library")) {
                table.addLibrary(new Library(ele.attributeValue("path"), null, LibraryType.Constant));
                continue;
            }
            if (name.equals("import-action-library")) {
                table.addLibrary(new Library(ele.attributeValue("path"), null, LibraryType.Action));
                continue;
            }
            if (name.equals("import-parameter-library")) {
                table.addLibrary(new Library(ele.attributeValue("path"), null, LibraryType.Parameter));
                continue;
            }
            if (!name.equals("remark")) continue;
            table.setRemark(ele.getText());
        }
        this.rebuildTable(table);
        return table;
    }

    private void rebuildTable(DecisionTable table) {
        List<Library> libraries = table.getLibraries();
        ResourceLibrary resLibraries = this.rulesRebuilder.getResourceLibraryBuilder().buildResourceLibrary(libraries);
        HashMap<String, String> namedMap = new HashMap<String, String>();
        for (Cell cell : table.getCellMap().values()) {
            List<Condition> conditions;
            if (cell.getAction() != null) {
                this.rulesRebuilder.rebuildAction(cell.getAction(), resLibraries, namedMap, false);
                continue;
            }
            if (cell.getValue() != null) {
                this.rulesRebuilder.rebuildValue(cell.getValue(), resLibraries, namedMap, false);
                continue;
            }
            if (cell.getJoint() == null || cell.getJoint() == null || cell.getJoint().getJunction() == null || (conditions = cell.getJoint().getConditions()) == null) continue;
            for (Condition condition : conditions) {
                Value value = condition.getValue();
                if (value == null) continue;
                this.rulesRebuilder.rebuildValue(value, resLibraries, namedMap, false);
            }
        }
        for (Column col : table.getColumns()) {
            String category = col.getVariableCategory();
            String name = col.getVariableName();
            if (StringUtils.isBlank((String)category) || StringUtils.isBlank((String)name)) continue;
            Variable variable = this.rulesRebuilder.getVariableByName(resLibraries.getVariableCategories(), category, name, namedMap);
            col.setDatatype(variable.getType());
            col.setVariableLabel(variable.getLabel());
        }
    }

    @Override
    public boolean support(String name) {
        return name.equals("decision-table");
    }

    public void setColumnParser(ColumnParser columnParser) {
        this.columnParser = columnParser;
    }

    public void setRowParser(RowParser rowParser) {
        this.rowParser = rowParser;
    }

    public void setCellParser(CellParser cellParser) {
        this.cellParser = cellParser;
    }

    public void setRulesRebuilder(RulesRebuilder rulesRebuilder) {
        this.rulesRebuilder = rulesRebuilder;
    }
}

