/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.parse.table;

import com.bstek.urule.action.Action;
import com.bstek.urule.model.table.Cell;
import com.bstek.urule.parse.ActionParser;
import com.bstek.urule.parse.Parser;
import com.bstek.urule.parse.ValueParser;
import com.bstek.urule.parse.table.JointParser;
import java.util.Collection;
import org.dom4j.Element;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class CellParser
implements Parser<Cell>,
ApplicationContextAware {
    private JointParser jointParser;
    private ValueParser valueParser;
    private Collection<ActionParser> actionParsers;

    @Override
    public Cell parse(Element element) {
        Cell cell = new Cell();
        cell.setRow(Integer.valueOf(element.attributeValue("row")));
        cell.setCol(Integer.valueOf(element.attributeValue("col")));
        cell.setRowspan(Integer.valueOf(element.attributeValue("rowspan")));
        block0: for (Object obj : element.elements()) {
            if (obj == null || !(obj instanceof Element)) continue;
            Element ele = (Element)obj;
            String name = ele.getName();
            if (this.jointParser.support(name)) {
                cell.setJoint(this.jointParser.parse(ele));
                continue;
            }
            if (this.valueParser.support(name)) {
                cell.setValue(this.valueParser.parse(ele));
                continue;
            }
            for (ActionParser parser : this.actionParsers) {
                if (!parser.support(name)) continue;
                cell.setAction((Action)parser.parse(ele));
                continue block0;
            }
        }
        return cell;
    }

    @Override
    public boolean support(String name) {
        return name.equals("cell");
    }

    public void setJointParser(JointParser jointParser) {
        this.jointParser = jointParser;
    }

    public void setValueParser(ValueParser valueParser) {
        this.valueParser = valueParser;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.actionParsers = applicationContext.getBeansOfType(ActionParser.class).values();
    }
}

