/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.parse.scorecard;

import com.bstek.urule.Configure;
import com.bstek.urule.RuleException;
import com.bstek.urule.builder.RulesRebuilder;
import com.bstek.urule.model.library.Datatype;
import com.bstek.urule.model.library.ResourceLibrary;
import com.bstek.urule.model.library.variable.Variable;
import com.bstek.urule.model.rule.Library;
import com.bstek.urule.model.rule.LibraryType;
import com.bstek.urule.model.rule.Value;
import com.bstek.urule.model.scorecard.AssignTargetType;
import com.bstek.urule.model.scorecard.AttributeRow;
import com.bstek.urule.model.scorecard.CardCell;
import com.bstek.urule.model.scorecard.CustomCol;
import com.bstek.urule.model.scorecard.ScorecardDefinition;
import com.bstek.urule.model.scorecard.ScoringType;
import com.bstek.urule.model.table.Condition;
import com.bstek.urule.model.table.Joint;
import com.bstek.urule.parse.Parser;
import com.bstek.urule.parse.scorecard.AttributeRowParser;
import com.bstek.urule.parse.scorecard.CardCellParser;
import com.bstek.urule.parse.scorecard.CustomColParser;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;

public class ScorecardParser
implements Parser<ScorecardDefinition> {
    private CardCellParser cardCellParser;
    private AttributeRowParser attributeRowParser = new AttributeRowParser();
    private CustomColParser customColParser = new CustomColParser();
    private RulesRebuilder rulesRebuilder;

    @Override
    public ScorecardDefinition parse(Element element) {
        String debug;
        String enabled;
        String expiresDate;
        ScorecardDefinition card = new ScorecardDefinition();
        card.setName(element.attributeValue("name"));
        card.setScoringType(ScoringType.valueOf(element.attributeValue("scoring-type")));
        card.setAssignTargetType(AssignTargetType.valueOf(element.attributeValue("assign-target-type")));
        card.setVariableCategory(element.attributeValue("var-category"));
        card.setVariableName(element.attributeValue("var"));
        card.setVariableLabel(element.attributeValue("var-label"));
        String dt = element.attributeValue("datatype");
        if (StringUtils.isNotBlank((String)dt)) {
            card.setDatatype(Datatype.valueOf(dt));
        }
        card.setScoringBean(element.attributeValue("custom-scoring-bean"));
        String salience = element.attributeValue("salience");
        if (StringUtils.isNotEmpty((String)salience)) {
            card.setSalience(Integer.valueOf(salience));
        }
        String effectiveDate = element.attributeValue("effective-date");
        SimpleDateFormat sd = new SimpleDateFormat(Configure.getDateFormat());
        if (StringUtils.isNotEmpty((String)effectiveDate)) {
            try {
                card.setEffectiveDate(sd.parse(effectiveDate));
            }
            catch (ParseException e) {
                throw new RuleException(e);
            }
        }
        if (StringUtils.isNotEmpty((String)(expiresDate = element.attributeValue("expires-date")))) {
            try {
                card.setExpiresDate(sd.parse(expiresDate));
            }
            catch (ParseException e) {
                throw new RuleException(e);
            }
        }
        if (StringUtils.isNotEmpty((String)(enabled = element.attributeValue("enabled")))) {
            card.setEnabled(Boolean.valueOf(enabled));
        }
        if (StringUtils.isNotEmpty((String)(debug = element.attributeValue("debug")))) {
            card.setDebug(Boolean.valueOf(debug));
        }
        card.setAttributeColWidth(element.attributeValue("attr-col-width"));
        card.setAttributeColName(element.attributeValue("attr-col-name"));
        card.setAttributeColVariableCategory(element.attributeValue("attr-col-category"));
        card.setConditionColName(element.attributeValue("condition-col-name"));
        card.setConditionColWidth(element.attributeValue("condition-col-width"));
        card.setScoreColName(element.attributeValue("score-col-name"));
        card.setScoreColWidth(element.attributeValue("score-col-width"));
        String weightSupport = element.attributeValue("weight-support");
        if (StringUtils.isNotBlank((String)weightSupport)) {
            card.setWeightSupport(Boolean.valueOf(weightSupport));
        }
        ArrayList<CardCell> cells = new ArrayList<CardCell>();
        ArrayList<AttributeRow> rows = new ArrayList<AttributeRow>();
        ArrayList<CustomCol> cols = new ArrayList<CustomCol>();
        card.setCells(cells);
        card.setRows(rows);
        card.setCustomCols(cols);
        for (Object obj : element.elements()) {
            if (obj == null || !(obj instanceof Element)) continue;
            Element ele = (Element)obj;
            String name = ele.getName();
            if (this.cardCellParser.support(name)) {
                cells.add(this.cardCellParser.parse(ele));
                continue;
            }
            if (this.attributeRowParser.support(name)) {
                rows.add(this.attributeRowParser.parse(ele));
                continue;
            }
            if (this.customColParser.support(name)) {
                cols.add(this.customColParser.parse(ele));
                continue;
            }
            if (name.equals("import-variable-library")) {
                card.addLibrary(new Library(ele.attributeValue("path"), null, LibraryType.Variable));
                continue;
            }
            if (name.equals("import-constant-library")) {
                card.addLibrary(new Library(ele.attributeValue("path"), null, LibraryType.Constant));
                continue;
            }
            if (name.equals("import-action-library")) {
                card.addLibrary(new Library(ele.attributeValue("path"), null, LibraryType.Action));
                continue;
            }
            if (name.equals("import-parameter-library")) {
                card.addLibrary(new Library(ele.attributeValue("path"), null, LibraryType.Parameter));
                continue;
            }
            if (!name.equals("remark")) continue;
            card.setRemark(ele.getText());
        }
        this.rebuildScorecard(card);
        return card;
    }

    private void rebuildScorecard(ScorecardDefinition card) {
        ResourceLibrary resLibraries = this.rulesRebuilder.getResourceLibraryBuilder().buildResourceLibrary(card.getLibraries());
        String category = card.getVariableCategory();
        String name = card.getVariableName();
        if (StringUtils.isNotBlank((String)category) && StringUtils.isNotBlank((String)name)) {
            Variable variable = this.rulesRebuilder.getVariableByName(resLibraries.getVariableCategories(), category, name, null);
            card.setVariableLabel(variable.getLabel());
            card.setDatatype(variable.getType());
        }
        String colCategory = card.getAttributeColVariableCategory();
        List<CardCell> cells = card.getCells();
        if (cells == null) {
            return;
        }
        for (CardCell cell : cells) {
            String varName;
            Value value;
            Joint joint = cell.getJoint();
            if (joint != null && joint.getConditions() != null) {
                for (Condition condition : joint.getConditions()) {
                    Value value2;
                    if (condition == null || (value2 = condition.getValue()) == null) continue;
                    this.rulesRebuilder.rebuildValue(value2, resLibraries, null, false);
                }
            }
            if ((value = cell.getValue()) != null) {
                this.rulesRebuilder.rebuildValue(value, resLibraries, null, false);
            }
            if (!StringUtils.isNotBlank((String)(varName = cell.getVariableName()))) continue;
            Variable variable = this.rulesRebuilder.getVariableByName(resLibraries.getVariableCategories(), colCategory, varName, null);
            cell.setDatatype(variable.getType());
            cell.setVariableLabel(variable.getLabel());
        }
    }

    public void setCardCellParser(CardCellParser cardCellParser) {
        this.cardCellParser = cardCellParser;
    }

    public void setRulesRebuilder(RulesRebuilder rulesRebuilder) {
        this.rulesRebuilder = rulesRebuilder;
    }

    @Override
    public boolean support(String name) {
        return name.equals("scorecard");
    }
}

