/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.parse.scorecard;

import com.bstek.urule.model.library.Datatype;
import com.bstek.urule.model.scorecard.CardCell;
import com.bstek.urule.model.scorecard.CellType;
import com.bstek.urule.parse.Parser;
import com.bstek.urule.parse.ValueParser;
import com.bstek.urule.parse.table.JointParser;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;

public class CardCellParser
implements Parser<CardCell> {
    private ValueParser valueParser;
    private JointParser jointParser;

    @Override
    public CardCell parse(Element element) {
        CardCell cell = new CardCell();
        cell.setType(CellType.valueOf(element.attributeValue("type")));
        cell.setCol(Integer.valueOf(element.attributeValue("col")));
        cell.setRow(Integer.valueOf(element.attributeValue("row")));
        String datatype = element.attributeValue("datatype");
        if (StringUtils.isNotBlank((String)datatype)) {
            cell.setDatatype(Datatype.valueOf(datatype));
        }
        cell.setVariableName(element.attributeValue("var"));
        cell.setVariableLabel(element.attributeValue("var-label"));
        cell.setWeight(element.attributeValue("weight"));
        for (Object obj : element.elements()) {
            if (obj == null || !(obj instanceof Element)) continue;
            Element ele = (Element)obj;
            if (this.valueParser.support(ele.getName())) {
                cell.setValue(this.valueParser.parse(ele));
                continue;
            }
            if (!this.jointParser.support(ele.getName())) continue;
            cell.setJoint(this.jointParser.parse(ele));
        }
        return cell;
    }

    public void setJointParser(JointParser jointParser) {
        this.jointParser = jointParser;
    }

    public void setValueParser(ValueParser valueParser) {
        this.valueParser = valueParser;
    }

    @Override
    public boolean support(String name) {
        return name.equals("card-cell");
    }
}

