/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.parse.flow;

import com.bstek.urule.model.flow.FlowDefinition;
import com.bstek.urule.model.flow.FlowNode;
import com.bstek.urule.model.rule.Library;
import com.bstek.urule.model.rule.LibraryType;
import com.bstek.urule.parse.Parser;
import com.bstek.urule.parse.flow.FlowNodeParser;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class FlowDefinitionParser
implements Parser<FlowDefinition>,
ApplicationContextAware {
    private Collection<FlowNodeParser> nodeParsers;

    @Override
    public FlowDefinition parse(Element element) {
        FlowDefinition flow = new FlowDefinition();
        flow.setId(element.attributeValue("id"));
        String debug = element.attributeValue("debug");
        if (StringUtils.isNotBlank((String)debug)) {
            flow.setDebug(Boolean.valueOf(debug));
        }
        ArrayList<FlowNode> nodes = new ArrayList<FlowNode>();
        block0: for (Object obj : element.elements()) {
            if (obj == null || !(obj instanceof Element)) continue;
            Element ele = (Element)obj;
            String name = ele.getName();
            if (name.equals("import-variable-library")) {
                flow.addLibrary(this.buildLibrary(ele, LibraryType.Variable));
                continue;
            }
            if (name.equals("import-constant-library")) {
                flow.addLibrary(this.buildLibrary(ele, LibraryType.Constant));
                continue;
            }
            if (name.equals("import-action-library")) {
                flow.addLibrary(this.buildLibrary(ele, LibraryType.Action));
                continue;
            }
            if (name.equals("import-parameter-library")) {
                flow.addLibrary(this.buildLibrary(ele, LibraryType.Parameter));
                continue;
            }
            for (FlowNodeParser parser : this.nodeParsers) {
                if (!parser.support(ele.getName())) continue;
                nodes.add((FlowNode)parser.parse(ele));
                continue block0;
            }
        }
        flow.setNodes(nodes);
        flow.buildConnectionToNode();
        return flow;
    }

    private Library buildLibrary(Element ele, LibraryType type) {
        String path = ele.attributeValue("path");
        if (path.endsWith(".xml")) {
            Library lib = new Library(path, null, type);
            return lib;
        }
        int versionPos = path.lastIndexOf(":");
        String version = path.substring(versionPos + 1, path.length());
        if (version.equals("LATEST")) {
            version = null;
        }
        path = path.substring(0, versionPos);
        Library lib = new Library(path, version, type);
        return lib;
    }

    @Override
    public boolean support(String name) {
        return name.equals("rule-flow");
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.nodeParsers = applicationContext.getBeansOfType(FlowNodeParser.class).values();
    }
}

