/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.parse.flow;

import com.bstek.urule.model.flow.DecisionItem;
import com.bstek.urule.model.flow.DecisionNode;
import com.bstek.urule.model.flow.DecisionType;
import com.bstek.urule.parse.flow.FlowNodeParser;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;

public class DecisionNodeParser
extends FlowNodeParser<DecisionNode> {
    @Override
    public DecisionNode parse(Element element) {
        DecisionNode decision = new DecisionNode(element.attributeValue("name"));
        decision.setEventBean(element.attributeValue("event-bean"));
        String decitionType = element.attributeValue("decision-type");
        if (StringUtils.isNotEmpty((String)decitionType)) {
            decision.setDecisionType(DecisionType.valueOf(decitionType));
        }
        decision.setX(element.attributeValue("x"));
        decision.setY(element.attributeValue("y"));
        decision.setWidth(element.attributeValue("width"));
        decision.setHeight(element.attributeValue("height"));
        decision.setConnections(this.parseConnections(element));
        ArrayList<DecisionItem> items = new ArrayList<DecisionItem>();
        for (Object obj : element.elements()) {
            Element ele;
            if (obj == null || !(obj instanceof Element) || !(ele = (Element)obj).getName().equals("item")) continue;
            DecisionItem item = this.parseDecisionItem(ele);
            items.add(item);
        }
        decision.setItems(items);
        return decision;
    }

    private DecisionItem parseDecisionItem(Element element) {
        DecisionItem item = new DecisionItem();
        item.setTo(element.attributeValue("connection"));
        String script = element.getStringValue();
        item.setScript(script);
        String percent = element.attributeValue("percent");
        if (StringUtils.isNotEmpty((String)percent)) {
            item.setPercent(Integer.valueOf(percent));
        }
        return item;
    }

    @Override
    public boolean support(String name) {
        return name.equals("decision");
    }
}

