/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.parse.decisiontree;

import com.bstek.urule.model.decisiontree.ConditionTreeNode;
import com.bstek.urule.model.decisiontree.TreeNodeType;
import com.bstek.urule.model.decisiontree.VariableTreeNode;
import com.bstek.urule.parse.LeftParser;
import com.bstek.urule.parse.Parser;
import com.bstek.urule.parse.decisiontree.ConditionTreeNodeParser;
import java.util.ArrayList;
import org.dom4j.Element;

public class VariableTreeNodeParser
implements Parser<VariableTreeNode> {
    private LeftParser leftParser;
    private ConditionTreeNodeParser conditionTreeNodeParser;

    @Override
    public VariableTreeNode parse(Element element) {
        VariableTreeNode node = new VariableTreeNode();
        node.setNodeType(TreeNodeType.variable);
        ArrayList<ConditionTreeNode> conditionTreeNodes = new ArrayList<ConditionTreeNode>();
        for (Object obj : element.elements()) {
            if (obj == null || !(obj instanceof Element)) continue;
            Element ele = (Element)obj;
            String name = ele.getName();
            if (name.equals("left")) {
                node.setLeft(this.leftParser.parse(ele));
                continue;
            }
            if (!this.conditionTreeNodeParser.support(name)) continue;
            ConditionTreeNode cn = this.conditionTreeNodeParser.parse(ele);
            cn.setParentNode(node);
            conditionTreeNodes.add(cn);
        }
        if (conditionTreeNodes.size() > 0) {
            node.setConditionTreeNodes(conditionTreeNodes);
        }
        return node;
    }

    public void setConditionTreeNodeParser(ConditionTreeNodeParser conditionTreeNodeParser) {
        this.conditionTreeNodeParser = conditionTreeNodeParser;
    }

    public void setLeftParser(LeftParser leftParser) {
        this.leftParser = leftParser;
    }

    @Override
    public boolean support(String name) {
        return name.equals("variable-tree-node");
    }
}

