/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.parse.decisiontree;

import com.bstek.urule.Configure;
import com.bstek.urule.RuleException;
import com.bstek.urule.action.Action;
import com.bstek.urule.builder.RulesRebuilder;
import com.bstek.urule.model.decisiontree.ActionTreeNode;
import com.bstek.urule.model.decisiontree.ConditionTreeNode;
import com.bstek.urule.model.decisiontree.DecisionTree;
import com.bstek.urule.model.decisiontree.TreeNode;
import com.bstek.urule.model.decisiontree.VariableTreeNode;
import com.bstek.urule.model.library.ResourceLibrary;
import com.bstek.urule.model.library.variable.Variable;
import com.bstek.urule.model.rule.Library;
import com.bstek.urule.model.rule.LibraryType;
import com.bstek.urule.model.rule.Value;
import com.bstek.urule.model.rule.lhs.Left;
import com.bstek.urule.model.rule.lhs.LeftPart;
import com.bstek.urule.model.rule.lhs.VariableLeftPart;
import com.bstek.urule.parse.Parser;
import com.bstek.urule.parse.decisiontree.VariableTreeNodeParser;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;

public class DecisionTreeParser
implements Parser<DecisionTree> {
    private VariableTreeNodeParser variableTreeNodeParser;
    private RulesRebuilder rulesRebuilder;

    @Override
    public DecisionTree parse(Element element) {
        String debug;
        String enabled;
        String expiresDate;
        DecisionTree tree = new DecisionTree();
        String salience = element.attributeValue("salience");
        if (StringUtils.isNotEmpty((String)salience)) {
            tree.setSalience(Integer.valueOf(salience));
        }
        String effectiveDate = element.attributeValue("effective-date");
        SimpleDateFormat sd = new SimpleDateFormat(Configure.getDateFormat());
        if (StringUtils.isNotEmpty((String)effectiveDate)) {
            try {
                tree.setEffectiveDate(sd.parse(effectiveDate));
            }
            catch (ParseException e) {
                throw new RuleException(e);
            }
        }
        if (StringUtils.isNotEmpty((String)(expiresDate = element.attributeValue("expires-date")))) {
            try {
                tree.setExpiresDate(sd.parse(expiresDate));
            }
            catch (ParseException e) {
                throw new RuleException(e);
            }
        }
        if (StringUtils.isNotEmpty((String)(enabled = element.attributeValue("enabled")))) {
            tree.setEnabled(Boolean.valueOf(enabled));
        }
        if (StringUtils.isNotEmpty((String)(debug = element.attributeValue("debug")))) {
            tree.setDebug(Boolean.valueOf(debug));
        }
        ArrayList<Library> libs = new ArrayList<Library>();
        for (Object obj : element.elements()) {
            if (obj == null || !(obj instanceof Element)) continue;
            Element ele = (Element)obj;
            String name = ele.getName();
            if (this.variableTreeNodeParser.support(name)) {
                tree.setVariableTreeNode(this.variableTreeNodeParser.parse(ele));
            }
            if (name.equals("import-variable-library")) {
                libs.add(new Library(ele.attributeValue("path"), null, LibraryType.Variable));
                continue;
            }
            if (name.equals("import-constant-library")) {
                libs.add(new Library(ele.attributeValue("path"), null, LibraryType.Constant));
                continue;
            }
            if (name.equals("import-action-library")) {
                libs.add(new Library(ele.attributeValue("path"), null, LibraryType.Action));
                continue;
            }
            if (name.equals("import-parameter-library")) {
                libs.add(new Library(ele.attributeValue("path"), null, LibraryType.Parameter));
                continue;
            }
            if (!name.equals("remark")) continue;
            tree.setRemark(ele.getText());
        }
        tree.setLibraries(libs);
        ResourceLibrary resourceLibrary = this.rulesRebuilder.getResourceLibraryBuilder().buildResourceLibrary(libs);
        this.rebuildTreeNode(resourceLibrary, tree.getVariableTreeNode());
        return tree;
    }

    private void rebuildTreeNode(ResourceLibrary resourceLibrary, TreeNode treeNode) {
        block13: {
            ActionTreeNode actionNode;
            List<Action> actions;
            block14: {
                List<VariableTreeNode> list;
                List<ConditionTreeNode> conditionNodes;
                List<ActionTreeNode> actionNodes;
                block12: {
                    List<ConditionTreeNode> nodes;
                    LeftPart part;
                    if (treeNode == null) {
                        return;
                    }
                    if (!(treeNode instanceof VariableTreeNode)) break block12;
                    VariableTreeNode varNode = (VariableTreeNode)treeNode;
                    Left left = varNode.getLeft();
                    if (left != null && (part = left.getLeftPart()) != null && part instanceof VariableLeftPart) {
                        VariableLeftPart varPart = (VariableLeftPart)part;
                        String string = varPart.getVariableCategory();
                        String name = varPart.getVariableName();
                        if (StringUtils.isNotBlank((String)string) && StringUtils.isNotBlank((String)name)) {
                            Variable var = this.rulesRebuilder.getVariableByName(resourceLibrary.getVariableCategories(), string, name, null);
                            varPart.setDatatype(var.getType());
                            varPart.setVariableLabel(var.getLabel());
                        }
                    }
                    if ((nodes = varNode.getConditionTreeNodes()) == null) break block13;
                    for (ConditionTreeNode conditionTreeNode : nodes) {
                        this.rebuildTreeNode(resourceLibrary, conditionTreeNode);
                    }
                    break block13;
                }
                if (!(treeNode instanceof ConditionTreeNode)) break block14;
                ConditionTreeNode node = (ConditionTreeNode)treeNode;
                Value value = node.getValue();
                if (value != null) {
                    this.rulesRebuilder.rebuildValue(value, resourceLibrary, null, false);
                }
                if ((actionNodes = node.getActionTreeNodes()) != null) {
                    for (ActionTreeNode actionTreeNode : actionNodes) {
                        this.rebuildTreeNode(resourceLibrary, actionTreeNode);
                    }
                }
                if ((conditionNodes = node.getConditionTreeNodes()) != null) {
                    for (ConditionTreeNode conditionNode : conditionNodes) {
                        this.rebuildTreeNode(resourceLibrary, conditionNode);
                    }
                }
                if ((list = node.getVariableTreeNodes()) == null) break block13;
                for (VariableTreeNode varNode : list) {
                    this.rebuildTreeNode(resourceLibrary, varNode);
                }
                break block13;
            }
            if (treeNode instanceof ActionTreeNode && (actions = (actionNode = (ActionTreeNode)treeNode).getActions()) != null) {
                for (Action action : actions) {
                    if (action == null) continue;
                    this.rulesRebuilder.rebuildAction(action, resourceLibrary, null, false);
                }
            }
        }
    }

    public void setVariableTreeNodeParser(VariableTreeNodeParser variableTreeNodeParser) {
        this.variableTreeNodeParser = variableTreeNodeParser;
    }

    @Override
    public boolean support(String name) {
        return name.equals("decision-tree");
    }

    public void setRulesRebuilder(RulesRebuilder rulesRebuilder) {
        this.rulesRebuilder = rulesRebuilder;
    }
}

