/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.parse.decisiontree;

import com.bstek.urule.model.decisiontree.ActionTreeNode;
import com.bstek.urule.model.decisiontree.ConditionTreeNode;
import com.bstek.urule.model.decisiontree.TreeNodeType;
import com.bstek.urule.model.decisiontree.VariableTreeNode;
import com.bstek.urule.model.rule.Op;
import com.bstek.urule.parse.Parser;
import com.bstek.urule.parse.ValueParser;
import com.bstek.urule.parse.decisiontree.ActionTreeNodeParser;
import com.bstek.urule.parse.decisiontree.VariableTreeNodeParser;
import java.util.ArrayList;
import org.dom4j.Element;

public class ConditionTreeNodeParser
implements Parser<ConditionTreeNode> {
    private ValueParser valueParser;
    private VariableTreeNodeParser variableTreeNodeParser;
    private ActionTreeNodeParser actionTreeNodeParser;

    @Override
    public ConditionTreeNode parse(Element element) {
        ConditionTreeNode node = new ConditionTreeNode();
        node.setNodeType(TreeNodeType.condition);
        node.setOp(Op.valueOf(element.attributeValue("op")));
        ArrayList<ConditionTreeNode> conditionTreeNodes = new ArrayList<ConditionTreeNode>();
        ArrayList<ActionTreeNode> actionTreeNodes = new ArrayList<ActionTreeNode>();
        ArrayList<VariableTreeNode> variableTreeNodes = new ArrayList<VariableTreeNode>();
        for (Object obj : element.elements()) {
            if (obj == null || !(obj instanceof Element)) continue;
            Element ele = (Element)obj;
            String name = ele.getName();
            if (this.valueParser.support(name)) {
                node.setValue(this.valueParser.parse(ele));
                continue;
            }
            if (this.support(name)) {
                ConditionTreeNode cn = this.parse(ele);
                cn.setParentNode(node);
                conditionTreeNodes.add(cn);
                continue;
            }
            if (this.variableTreeNodeParser.support(name)) {
                VariableTreeNode vn = this.variableTreeNodeParser.parse(ele);
                vn.setParentNode(node);
                variableTreeNodes.add(vn);
                continue;
            }
            if (!this.actionTreeNodeParser.support(name)) continue;
            ActionTreeNode an = this.actionTreeNodeParser.parse(ele);
            an.setParentNode(node);
            actionTreeNodes.add(an);
        }
        if (conditionTreeNodes.size() > 0) {
            node.setConditionTreeNodes(conditionTreeNodes);
        }
        if (actionTreeNodes.size() > 0) {
            node.setActionTreeNodes(actionTreeNodes);
        }
        if (variableTreeNodes.size() > 0) {
            node.setVariableTreeNodes(variableTreeNodes);
        }
        return node;
    }

    public void setValueParser(ValueParser valueParser) {
        this.valueParser = valueParser;
    }

    public void setActionTreeNodeParser(ActionTreeNodeParser actionTreeNodeParser) {
        this.actionTreeNodeParser = actionTreeNodeParser;
    }

    public void setVariableTreeNodeParser(VariableTreeNodeParser variableTreeNodeParser) {
        this.variableTreeNodeParser = variableTreeNodeParser;
    }

    @Override
    public boolean support(String name) {
        return name.equals("condition-tree-node");
    }
}

