/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.parse.decisiontree;

import com.bstek.urule.action.Action;
import com.bstek.urule.model.decisiontree.ActionTreeNode;
import com.bstek.urule.model.decisiontree.TreeNodeType;
import com.bstek.urule.parse.ActionParser;
import com.bstek.urule.parse.Parser;
import java.util.ArrayList;
import java.util.Collection;
import org.dom4j.Element;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ActionTreeNodeParser
implements Parser<ActionTreeNode>,
ApplicationContextAware {
    private Collection<ActionParser> actionParsers;

    @Override
    public ActionTreeNode parse(Element element) {
        ActionTreeNode node = new ActionTreeNode();
        node.setNodeType(TreeNodeType.action);
        ArrayList<Action> actions = new ArrayList<Action>();
        block0: for (Object obj : element.elements()) {
            if (obj == null || !(obj instanceof Element)) continue;
            Element ele = (Element)obj;
            String name = ele.getName();
            for (ActionParser actionParser : this.actionParsers) {
                if (!actionParser.support(name)) continue;
                actions.add((Action)actionParser.parse(ele));
                continue block0;
            }
        }
        node.setActions(actions);
        return node;
    }

    @Override
    public boolean support(String name) {
        return name.equals("action-tree-node");
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.actionParsers = context.getBeansOfType(ActionParser.class).values();
    }
}

