/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.parse;

import com.bstek.urule.model.library.Datatype;
import com.bstek.urule.model.rule.AbstractValue;
import com.bstek.urule.model.rule.CommonFunctionValue;
import com.bstek.urule.model.rule.ConstantValue;
import com.bstek.urule.model.rule.MethodValue;
import com.bstek.urule.model.rule.NamedReferenceValue;
import com.bstek.urule.model.rule.Parameter;
import com.bstek.urule.model.rule.ParameterValue;
import com.bstek.urule.model.rule.SimpleValue;
import com.bstek.urule.model.rule.Value;
import com.bstek.urule.model.rule.ValueType;
import com.bstek.urule.model.rule.VariableCategoryValue;
import com.bstek.urule.model.rule.VariableValue;
import com.bstek.urule.model.rule.lhs.CommonFunctionParameter;
import com.bstek.urule.parse.AbstractParser;
import com.bstek.urule.parse.ComplexArithmeticParser;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;

public class ValueParser
extends AbstractParser<Value> {
    private ComplexArithmeticParser arithmeticParser;

    @Override
    public Value parse(Element element) {
        AbstractValue value;
        AbstractValue av = null;
        ValueType type = ValueType.valueOf(element.attributeValue("type"));
        if (type.equals((Object)ValueType.Input)) {
            SimpleValue sv = new SimpleValue();
            String content = element.attributeValue("content");
            if (StringUtils.isNotEmpty((String)content)) {
                sv.setContent(StringEscapeUtils.unescapeXml((String)content));
            }
            av = sv;
        } else if (type.equals((Object)ValueType.Parameter)) {
            ParameterValue pv = new ParameterValue();
            pv.setVariableName(element.attributeValue("var"));
            pv.setVariableLabel(element.attributeValue("var-label"));
            av = pv;
        } else if (type.equals((Object)ValueType.Variable)) {
            String variableCategory;
            String datatype;
            String variableLabel;
            VariableValue vv = new VariableValue();
            String variable = element.attributeValue("var");
            if (StringUtils.isNotEmpty((String)variable)) {
                vv.setVariableName(variable);
            }
            if (StringUtils.isNotEmpty((String)(variableLabel = element.attributeValue("var-label")))) {
                vv.setVariableLabel(variableLabel);
            }
            if (StringUtils.isNotEmpty((String)(datatype = element.attributeValue("datatype")))) {
                vv.setDatatype(Datatype.valueOf(datatype));
            }
            if (StringUtils.isNotEmpty((String)(variableCategory = element.attributeValue("var-category")))) {
                vv.setVariableCategory(variableCategory);
            }
            av = vv;
        } else if (type.equals((Object)ValueType.VariableCategory)) {
            String variableCategory = element.attributeValue("var-category");
            av = new VariableCategoryValue(variableCategory);
        } else if (type.equals((Object)ValueType.Method)) {
            MethodValue mv = new MethodValue();
            String beanName = element.attributeValue("bean-name");
            mv.setBeanId(beanName);
            String beanLabel = element.attributeValue("bean-label");
            mv.setBeanLabel(beanLabel);
            String methodName = element.attributeValue("method-name");
            mv.setMethodName(methodName);
            String methodLabel = element.attributeValue("method-label");
            mv.setMethodLabel(methodLabel);
            List<Parameter> parameters = this.parseParameters(element, this);
            mv.setParameters(parameters);
            av = mv;
        } else if (type.equals((Object)ValueType.CommonFunction)) {
            value = new CommonFunctionValue();
            ((CommonFunctionValue)value).setName(element.attributeValue("function-name"));
            ((CommonFunctionValue)value).setLabel(element.attributeValue("function-label"));
            for (Object obj : element.elements()) {
                Element ele;
                if (!(obj instanceof Element) || !(ele = (Element)obj).getName().equals("function-parameter")) continue;
                CommonFunctionParameter p = new CommonFunctionParameter();
                p.setName(ele.attributeValue("name"));
                p.setProperty(ele.attributeValue("property-name"));
                p.setPropertyLabel(ele.attributeValue("property-name"));
                for (Object object : ele.elements()) {
                    Element e;
                    if (!(object instanceof Element) || !(e = (Element)object).getName().equals("value")) continue;
                    p.setObjectParameter(this.parse(e));
                }
                ((CommonFunctionValue)value).setParameter(p);
            }
            av = value;
        } else if (type.equals((Object)ValueType.NamedReference)) {
            value = new NamedReferenceValue();
            ((NamedReferenceValue)value).setReferenceName(element.attributeValue("reference-name"));
            ((NamedReferenceValue)value).setPropertyName(element.attributeValue("property-name"));
            ((NamedReferenceValue)value).setPropertyLabel(element.attributeValue("property-label"));
            ((NamedReferenceValue)value).setDatatype(Datatype.valueOf(element.attributeValue("datatype")));
            av = value;
        } else {
            String constantCategory;
            String constantLabel;
            ConstantValue cv = new ConstantValue();
            String constant = element.attributeValue("const");
            if (StringUtils.isNotEmpty((String)constant)) {
                cv.setConstantName(constant);
            }
            if (StringUtils.isNotEmpty((String)(constantLabel = element.attributeValue("const-label")))) {
                cv.setConstantLabel(constantLabel);
            }
            if (StringUtils.isNotEmpty((String)(constantCategory = element.attributeValue("const-category")))) {
                cv.setConstantCategory(constantCategory);
            }
            av = cv;
        }
        for (Object obj : element.elements()) {
            Element ele;
            String name;
            if (obj == null || !(obj instanceof Element) || !this.arithmeticParser.support(name = (ele = (Element)obj).getName())) continue;
            av.setArithmetic(this.arithmeticParser.parse(ele));
            break;
        }
        return av;
    }

    @Override
    public boolean support(String name) {
        return name.equals("value");
    }

    public void setArithmeticParser(ComplexArithmeticParser arithmeticParser) {
        this.arithmeticParser = arithmeticParser;
    }
}

