/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.parse;

import com.bstek.urule.model.library.Datatype;
import com.bstek.urule.model.library.action.Method;
import com.bstek.urule.model.library.action.Parameter;
import com.bstek.urule.model.library.action.SpringBean;
import com.bstek.urule.parse.Parser;
import org.dom4j.Element;

public class SpringBeanParser
implements Parser<SpringBean> {
    @Override
    public SpringBean parse(Element element) {
        SpringBean bean = new SpringBean();
        bean.setId(element.attributeValue("id"));
        for (Object obj : element.elements()) {
            Element ele;
            if (obj == null || !(obj instanceof Element) || !(ele = (Element)obj).getName().equals("method")) continue;
            Method method = this.parseMethod(ele);
            bean.addMethod(method);
        }
        return bean;
    }

    private Method parseMethod(Element element) {
        Method method = new Method();
        method.setName(element.attributeValue("name"));
        for (Object obj : element.elements()) {
            Element ele;
            if (obj == null || !(obj instanceof Element) || !(ele = (Element)obj).getName().equals("parameter")) continue;
            Parameter parameter = new Parameter();
            parameter.setType(Datatype.valueOf(ele.attributeValue("type")));
            method.addParameter(parameter);
        }
        return method;
    }

    @Override
    public boolean support(String name) {
        return name.equals("spring-bean");
    }
}

