/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.parse;

import com.bstek.urule.builder.RulesRebuilder;
import com.bstek.urule.model.rule.Library;
import com.bstek.urule.model.rule.LibraryType;
import com.bstek.urule.model.rule.Rule;
import com.bstek.urule.model.rule.RuleSet;
import com.bstek.urule.parse.LoopRuleParser;
import com.bstek.urule.parse.Parser;
import com.bstek.urule.parse.RuleParser;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;

public class RuleSetParser
implements Parser<RuleSet> {
    private RuleParser ruleParser;
    private LoopRuleParser loopRuleParser;
    private RulesRebuilder rulesRebuilder;

    @Override
    public RuleSet parse(Element element) {
        RuleSet ruleSet = new RuleSet();
        String parameterLibrary = element.attributeValue("parameter-library");
        if (StringUtils.isNotEmpty((String)parameterLibrary)) {
            ruleSet.addLibrary(new Library(parameterLibrary, null, LibraryType.Parameter));
        }
        ArrayList<Rule> rules = new ArrayList<Rule>();
        for (Object obj : element.elements()) {
            if (obj == null || !(obj instanceof Element)) continue;
            Element ele = (Element)obj;
            String name = ele.getName();
            if (this.ruleParser.support(name)) {
                rules.add(this.ruleParser.parse(ele));
                continue;
            }
            if (this.loopRuleParser.support(name)) {
                rules.add(this.loopRuleParser.parse(ele));
                continue;
            }
            if (name.equals("import-variable-library")) {
                ruleSet.addLibrary(new Library(ele.attributeValue("path"), null, LibraryType.Variable));
                continue;
            }
            if (name.equals("import-constant-library")) {
                ruleSet.addLibrary(new Library(ele.attributeValue("path"), null, LibraryType.Constant));
                continue;
            }
            if (name.equals("import-action-library")) {
                ruleSet.addLibrary(new Library(ele.attributeValue("path"), null, LibraryType.Action));
                continue;
            }
            if (name.equals("import-parameter-library")) {
                ruleSet.addLibrary(new Library(ele.attributeValue("path"), null, LibraryType.Parameter));
                continue;
            }
            if (!name.equals("remark")) continue;
            ruleSet.setRemark(ele.getText());
        }
        ruleSet.setRules(rules);
        this.rulesRebuilder.rebuildRules(ruleSet.getLibraries(), rules);
        return ruleSet;
    }

    public void setRulesRebuilder(RulesRebuilder rulesRebuilder) {
        this.rulesRebuilder = rulesRebuilder;
    }

    @Override
    public boolean support(String name) {
        return name.equals("rule-set");
    }

    public void setRuleParser(RuleParser ruleParser) {
        this.ruleParser = ruleParser;
    }

    public void setLoopRuleParser(LoopRuleParser loopRuleParser) {
        this.loopRuleParser = loopRuleParser;
    }
}

