/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.parse;

import com.bstek.urule.model.library.Datatype;
import com.bstek.urule.model.rule.Op;
import com.bstek.urule.model.rule.lhs.Criterion;
import com.bstek.urule.model.rule.lhs.JunctionType;
import com.bstek.urule.model.rule.lhs.NamedItem;
import com.bstek.urule.model.rule.lhs.NamedJunction;
import com.bstek.urule.parse.CriterionParser;
import com.bstek.urule.parse.ValueParser;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;

public class NamedJunctionParser
extends CriterionParser {
    private ValueParser valueParser;

    @Override
    public Criterion parse(Element element) {
        NamedJunction junction = new NamedJunction();
        junction.setReferenceName(element.attributeValue("reference-name"));
        junction.setVariableCategory(element.attributeValue("var-category"));
        junction.setJunctionType(JunctionType.valueOf(element.attributeValue("junction-type")));
        ArrayList<NamedItem> items = new ArrayList<NamedItem>();
        junction.setItems(items);
        for (Object obj : element.elements()) {
            Element ele;
            String name;
            if (obj == null || !(obj instanceof Element) || !(name = (ele = (Element)obj).getName()).equals("named-criteria")) continue;
            items.add(this.parseNamedItem(ele));
        }
        return junction;
    }

    private NamedItem parseNamedItem(Element element) {
        String datatype;
        String variableLabel;
        NamedItem item = new NamedItem();
        String variable = element.attributeValue("var");
        if (StringUtils.isNotEmpty((String)variable)) {
            item.setVariableName(variable);
        }
        if (StringUtils.isNotEmpty((String)(variableLabel = element.attributeValue("var-label")))) {
            item.setVariableLabel(variableLabel);
        }
        if (StringUtils.isNotEmpty((String)(datatype = element.attributeValue("datatype")))) {
            item.setDatatype(Datatype.valueOf(datatype));
        }
        Op op = Op.valueOf(element.attributeValue("op"));
        for (Object obj : element.elements()) {
            Element ele;
            if (obj == null || !(obj instanceof Element) || !this.valueParser.support((ele = (Element)obj).getName())) continue;
            item.setValue(this.valueParser.parse(ele));
            break;
        }
        item.setOp(op);
        return item;
    }

    public void setValueParser(ValueParser valueParser) {
        this.valueParser = valueParser;
    }

    @Override
    public boolean support(String name) {
        return name.equals("named-atom");
    }
}

