/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.parse;

import com.bstek.urule.model.rule.lhs.Criterion;
import com.bstek.urule.model.rule.lhs.Lhs;
import com.bstek.urule.parse.CriterionParser;
import com.bstek.urule.parse.Parser;
import java.util.Collection;
import org.dom4j.Element;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class LhsParser
implements Parser<Lhs>,
ApplicationContextAware {
    private Collection<CriterionParser> criterionParsers;

    @Override
    public Lhs parse(Element element) {
        Lhs lhs = new Lhs();
        lhs.setCriterion(this.parseCriterion(element));
        return lhs;
    }

    public Criterion parseCriterion(Element element) {
        Criterion criterion = null;
        for (Object obj : element.elements()) {
            if (obj == null || !(obj instanceof Element)) continue;
            Element ele = (Element)obj;
            String name = ele.getName();
            for (CriterionParser parser : this.criterionParsers) {
                if (parser.support(name) && (criterion = (Criterion)parser.parse(ele)) != null) break;
            }
        }
        return criterion;
    }

    @Override
    public boolean support(String name) {
        return name.equals("if");
    }

    public Collection<CriterionParser> getCriterionParsers() {
        return this.criterionParsers;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.criterionParsers = applicationContext.getBeansOfType(CriterionParser.class).values();
    }
}

