/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.parse;

import com.bstek.urule.RuleException;
import com.bstek.urule.model.library.Datatype;
import com.bstek.urule.model.rule.lhs.CommonFunctionLeftPart;
import com.bstek.urule.model.rule.lhs.CommonFunctionParameter;
import com.bstek.urule.model.rule.lhs.FunctionLeftPart;
import com.bstek.urule.model.rule.lhs.Left;
import com.bstek.urule.model.rule.lhs.LeftType;
import com.bstek.urule.model.rule.lhs.MethodLeftPart;
import com.bstek.urule.model.rule.lhs.VariableLeftPart;
import com.bstek.urule.parse.AbstractParser;
import com.bstek.urule.parse.SimpleArithmeticParser;
import com.bstek.urule.parse.ValueParser;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;

public class LeftParser
extends AbstractParser<Left> {
    private SimpleArithmeticParser arithmeticParser;
    private ValueParser valueParser;

    @Override
    public Left parse(Element element) {
        Left left = new Left();
        String type = element.attributeValue("type");
        if (StringUtils.isNotEmpty((String)type)) {
            left.setType(LeftType.valueOf(type));
        } else {
            left.setType(LeftType.variable);
        }
        switch (left.getType()) {
            case variable: {
                left.setLeftPart(this.buildVariableLeftPart(element));
                break;
            }
            case function: {
                left.setLeftPart(this.buildFunctionLeftPart(element));
                break;
            }
            case method: {
                left.setLeftPart(this.buildMethodLeftPart(element));
                break;
            }
            case parameter: {
                left.setLeftPart(this.buildVariableLeftPart(element));
                break;
            }
            case commonfunction: {
                left.setLeftPart(this.buildCommonFunctionLeftPart(element));
                break;
            }
            case NamedReference: {
                throw new RuleException("Not support reference type.");
            }
            case all: {
                throw new RuleException("Not support all type.");
            }
            case exist: {
                throw new RuleException("Not support exist type.");
            }
            case collect: {
                throw new RuleException("Not support collect type.");
            }
            case eval: {
                throw new RuleException("Not support eval type.");
            }
        }
        for (Object obj : element.elements()) {
            Element ele;
            if (obj == null || !(obj instanceof Element) || !this.arithmeticParser.support((ele = (Element)obj).getName())) continue;
            left.setArithmetic(this.arithmeticParser.parse(ele));
        }
        return left;
    }

    private CommonFunctionLeftPart buildCommonFunctionLeftPart(Element element) {
        CommonFunctionLeftPart part = new CommonFunctionLeftPart();
        part.setName(element.attributeValue("function-name"));
        part.setLabel(element.attributeValue("function-label"));
        for (Object obj : element.elements()) {
            Element ele;
            if (!(obj instanceof Element) || !(ele = (Element)obj).getName().equals("function-parameter")) continue;
            CommonFunctionParameter p = new CommonFunctionParameter();
            p.setName(ele.attributeValue("name"));
            p.setProperty(ele.attributeValue("property-name"));
            p.setPropertyLabel(ele.attributeValue("property-label"));
            for (Object object : ele.elements()) {
                Element e;
                if (!(object instanceof Element) || !(e = (Element)object).getName().equals("value")) continue;
                p.setObjectParameter(this.valueParser.parse(e));
            }
            part.setParameter(p);
        }
        return part;
    }

    private MethodLeftPart buildMethodLeftPart(Element element) {
        MethodLeftPart part = new MethodLeftPart();
        part.setBeanId(element.attributeValue("bean-name"));
        part.setBeanLabel(element.attributeValue("bean-label"));
        part.setMethodLabel(element.attributeValue("method-label"));
        part.setMethodName(element.attributeValue("method-name"));
        part.setParameters(this.parseParameters(element, this.valueParser));
        return part;
    }

    private FunctionLeftPart buildFunctionLeftPart(Element element) {
        FunctionLeftPart part = new FunctionLeftPart();
        part.setName(element.attributeValue("name"));
        part.setParameters(this.parseParameters(element, this.valueParser));
        return part;
    }

    private VariableLeftPart buildVariableLeftPart(Element element) {
        String datatype;
        String variableCategory;
        String variableLabel;
        VariableLeftPart part = new VariableLeftPart();
        String variable = element.attributeValue("var");
        if (StringUtils.isNotEmpty((String)variable)) {
            part.setVariableName(variable);
        }
        if (StringUtils.isNotEmpty((String)(variableLabel = element.attributeValue("var-label")))) {
            part.setVariableLabel(variableLabel);
        }
        if (StringUtils.isNotEmpty((String)(variableCategory = element.attributeValue("var-category")))) {
            part.setVariableCategory(variableCategory);
        }
        if (StringUtils.isNotEmpty((String)(datatype = element.attributeValue("datatype")))) {
            part.setDatatype(Datatype.valueOf(datatype));
        }
        return part;
    }

    public void setValueParser(ValueParser valueParser) {
        this.valueParser = valueParser;
    }

    public void setArithmeticParser(SimpleArithmeticParser arithmeticParser) {
        this.arithmeticParser = arithmeticParser;
    }

    @Override
    public boolean support(String name) {
        return name.equals("left");
    }
}

