/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.parse;

import com.bstek.urule.model.library.Datatype;
import com.bstek.urule.model.library.constant.Constant;
import com.bstek.urule.model.library.constant.ConstantCategory;
import com.bstek.urule.model.library.constant.ConstantLibrary;
import com.bstek.urule.parse.Parser;
import java.util.ArrayList;
import org.dom4j.Element;

public class ConstantLibraryParser
implements Parser<ConstantLibrary> {
    public static final String BEAN_ID = "urule.constantLibraryParser";

    @Override
    public ConstantLibrary parse(Element element) {
        ArrayList<ConstantCategory> categories = new ArrayList<ConstantCategory>();
        for (Object obj : element.elements()) {
            Element ele;
            if (obj == null || !(obj instanceof Element) || !(ele = (Element)obj).getName().equals("category")) continue;
            categories.add(this.parseConstantCategory(ele));
        }
        ConstantLibrary library = new ConstantLibrary();
        library.setCategories(categories);
        return library;
    }

    private ConstantCategory parseConstantCategory(Element element) {
        ConstantCategory category = new ConstantCategory();
        category.setName(element.attributeValue("name"));
        category.setLabel(element.attributeValue("label"));
        for (Object obj : element.elements()) {
            Element ele;
            if (obj == null || !(obj instanceof Element) || !(ele = (Element)obj).getName().equals("constant")) continue;
            category.addConstant(this.parseConstant(ele));
        }
        return category;
    }

    private Constant parseConstant(Element element) {
        Constant constant = new Constant();
        constant.setName(element.attributeValue("name"));
        constant.setLabel(element.attributeValue("label"));
        constant.setType(Datatype.valueOf(element.attributeValue("type")));
        return constant;
    }

    @Override
    public boolean support(String name) {
        return name.equals("constant-library");
    }
}

