/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.parse;

import com.bstek.urule.model.library.Datatype;
import com.bstek.urule.model.library.action.ActionLibrary;
import com.bstek.urule.model.library.action.Method;
import com.bstek.urule.model.library.action.Parameter;
import com.bstek.urule.model.library.action.SpringBean;
import com.bstek.urule.parse.Parser;
import org.dom4j.Element;

public class ActionLibraryParser
implements Parser<ActionLibrary> {
    @Override
    public ActionLibrary parse(Element element) {
        ActionLibrary lib = new ActionLibrary();
        for (Object obj : element.elements()) {
            Element ele;
            if (obj == null || !(obj instanceof Element) || !(ele = (Element)obj).getName().equals("spring-bean")) continue;
            lib.addSpringBean(this.parseSpringBean(ele));
        }
        return lib;
    }

    private SpringBean parseSpringBean(Element element) {
        SpringBean bean = new SpringBean();
        bean.setId(element.attributeValue("id"));
        bean.setName(element.attributeValue("name"));
        for (Object obj : element.elements()) {
            if (obj == null || !(obj instanceof Element)) continue;
            Element ele = (Element)obj;
            Method method = new Method();
            method.setMethodName(ele.attributeValue("method-name"));
            method.setName(ele.attributeValue("name"));
            for (Object o : ele.elements()) {
                Element e;
                if (o == null || !(o instanceof Element) || !(e = (Element)o).getName().equals("parameter")) continue;
                Parameter parameter = new Parameter();
                parameter.setName(e.attributeValue("name"));
                parameter.setType(Datatype.valueOf(e.attributeValue("type")));
                method.addParameter(parameter);
            }
            bean.addMethod(method);
        }
        return bean;
    }

    @Override
    public boolean support(String name) {
        return name.equals("action-library");
    }
}

