/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.parse;

import com.bstek.urule.Configure;
import com.bstek.urule.RuleException;
import com.bstek.urule.model.rule.Rule;
import com.bstek.urule.parse.LhsParser;
import com.bstek.urule.parse.OtherParser;
import com.bstek.urule.parse.Parser;
import com.bstek.urule.parse.RhsParser;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;

public abstract class AbstractRuleParser<T>
implements Parser<T> {
    protected LhsParser lhsParser;
    protected RhsParser rhsParser;
    private OtherParser otherParser;

    public void parseRule(Rule rule, Element element) {
        String loop;
        String debug;
        String enabled;
        String expiresDate;
        rule.setName(element.attributeValue("name"));
        String salience = element.attributeValue("salience");
        if (StringUtils.isNotEmpty((String)salience)) {
            rule.setSalience(Integer.valueOf(salience));
        }
        String effectiveDate = element.attributeValue("effective-date");
        SimpleDateFormat sd = new SimpleDateFormat(Configure.getDateFormat());
        if (StringUtils.isNotEmpty((String)effectiveDate)) {
            try {
                rule.setEffectiveDate(sd.parse(effectiveDate));
            }
            catch (ParseException e) {
                throw new RuleException(e);
            }
        }
        if (StringUtils.isNotEmpty((String)(expiresDate = element.attributeValue("expires-date")))) {
            try {
                rule.setExpiresDate(sd.parse(expiresDate));
            }
            catch (ParseException e) {
                throw new RuleException(e);
            }
        }
        if (StringUtils.isNotEmpty((String)(enabled = element.attributeValue("enabled")))) {
            rule.setEnabled(Boolean.valueOf(enabled));
        }
        if (StringUtils.isNotEmpty((String)(debug = element.attributeValue("debug")))) {
            rule.setDebug(Boolean.valueOf(debug));
        }
        if (StringUtils.isNotEmpty((String)(loop = element.attributeValue("loop")))) {
            rule.setLoop(Boolean.valueOf(loop));
        }
        rule.setActivationGroup(element.attributeValue("activation-group"));
        rule.setAgendaGroup(element.attributeValue("agenda-group"));
        String autoFocus = element.attributeValue("auto-focus");
        if (StringUtils.isNotEmpty((String)autoFocus)) {
            rule.setAutoFocus(Boolean.valueOf(autoFocus));
        }
        rule.setRuleflowGroup(element.attributeValue("ruleflow-group"));
        for (Object obj : element.elements()) {
            if (obj == null || !(obj instanceof Element)) continue;
            Element ele = (Element)obj;
            if (this.lhsParser.support(ele.getName())) {
                rule.setLhs(this.lhsParser.parse(ele));
                continue;
            }
            if (this.rhsParser.support(ele.getName())) {
                rule.setRhs(this.rhsParser.parse(ele));
                continue;
            }
            if (this.otherParser.support(ele.getName())) {
                rule.setOther(this.otherParser.parse(ele));
                continue;
            }
            if (!ele.getName().equals("remark")) continue;
            rule.setRemark(ele.getText());
        }
    }

    public void setLhsParser(LhsParser lhsParser) {
        this.lhsParser = lhsParser;
    }

    public void setRhsParser(RhsParser rhsParser) {
        this.rhsParser = rhsParser;
    }

    public void setOtherParser(OtherParser otherParser) {
        this.otherParser = otherParser;
    }
}

