/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.model.scorecard.runtime;

import com.bstek.urule.Utils;
import com.bstek.urule.debug.MsgType;
import com.bstek.urule.model.scorecard.runtime.RowItem;
import com.bstek.urule.model.scorecard.runtime.Scorecard;
import com.bstek.urule.runtime.rete.Context;
import java.math.BigDecimal;
import java.util.List;

public class ScorecardImpl
implements Scorecard {
    private String name;
    private boolean debug;
    private List<RowItem> rowItems;

    public ScorecardImpl(String name, List<RowItem> rowItems, boolean debug) {
        this.name = name;
        this.rowItems = rowItems;
        this.debug = debug;
    }

    public BigDecimal executeSum(Context context) {
        BigDecimal result = new BigDecimal(0);
        for (RowItem row : this.rowItems) {
            BigDecimal score = Utils.toBigDecimal(row.getScore());
            row.setActualScore(score);
            result = result.add(score);
        }
        String msg = "+++\u6c42\u548c\u5f97\u5206\uff1a" + result;
        context.debugMsg(msg, MsgType.ScoreCard, this.debug);
        return result;
    }

    public BigDecimal executeWeightSum(Context context) {
        BigDecimal result = new BigDecimal(0);
        for (RowItem row : this.rowItems) {
            BigDecimal score = Utils.toBigDecimal(row.getScore());
            BigDecimal weight = Utils.toBigDecimal(row.getWeight());
            BigDecimal actualScore = score.multiply(weight);
            row.setActualScore(actualScore);
            result = result.add(actualScore);
        }
        String msg = "+++\u52a0\u6743\u6c42\u548c\u5f97\u5206\uff1a" + result;
        context.debugMsg(msg, MsgType.ScoreCard, this.debug);
        return result;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<RowItem> getRowItems() {
        return this.rowItems;
    }
}

