/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.model.scorecard.runtime;

import com.bstek.urule.RuleException;
import com.bstek.urule.Utils;
import com.bstek.urule.action.ActionValue;
import com.bstek.urule.debug.MsgType;
import com.bstek.urule.model.library.Datatype;
import com.bstek.urule.model.rule.Library;
import com.bstek.urule.model.rule.Rule;
import com.bstek.urule.model.scorecard.AssignTargetType;
import com.bstek.urule.model.scorecard.ScoringType;
import com.bstek.urule.model.scorecard.runtime.CellItem;
import com.bstek.urule.model.scorecard.runtime.RowItem;
import com.bstek.urule.model.scorecard.runtime.RowItemImpl;
import com.bstek.urule.model.scorecard.runtime.ScoreRuntimeValue;
import com.bstek.urule.model.scorecard.runtime.ScorecardImpl;
import com.bstek.urule.model.scorecard.runtime.ScoringStrategy;
import com.bstek.urule.runtime.KnowledgePackageWrapper;
import com.bstek.urule.runtime.KnowledgeSession;
import com.bstek.urule.runtime.KnowledgeSessionFactory;
import com.bstek.urule.runtime.rete.Context;
import com.bstek.urule.runtime.rete.ValueCompute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.annotate.JsonIgnore;

public class ScoreRule
extends Rule {
    private ScoringType scoringType;
    private String scoringBean;
    private AssignTargetType assignTargetType;
    private String variableCategory;
    private String variableName;
    private String variableLabel;
    private Datatype datatype;
    @JsonIgnore
    private List<Library> libraries;
    private KnowledgePackageWrapper knowledgePackageWrapper;
    private final Log log = LogFactory.getLog(this.getClass());

    public List<ActionValue> execute(Context context, Object matchedObject, List<Object> allMatchedObjects, Map<String, Object> variableMap) {
        KnowledgeSession parentSession = (KnowledgeSession)context.getWorkingMemory();
        List<Object> facts = parentSession.getAllFacts();
        KnowledgeSession session = KnowledgeSessionFactory.newKnowledgeSession(this.knowledgePackageWrapper.getKnowledgePackage(), context.getDebugMessageItems());
        for (Object fact : facts) {
            session.insert(fact);
        }
        boolean isdebug = false;
        if (this.getDebug() != null) {
            isdebug = this.getDebug();
        }
        List<ActionValue> values = session.fireRules(parentSession.getParameters()).getActionValues();
        HashMap<Integer, RowItemImpl> rowMap = new HashMap<Integer, RowItemImpl>();
        for (ActionValue value : values) {
            if (!(value.getValue() instanceof ScoreRuntimeValue)) continue;
            ScoreRuntimeValue scoreValue = (ScoreRuntimeValue)value.getValue();
            int rowNumber = scoreValue.getRowNumber();
            if (isdebug && Utils.isDebug()) {
                String msg = "---\u884c" + rowNumber + ",\u5f97\u5206\uff1a" + scoreValue.getValue();
                context.debugMsg(msg, MsgType.ScoreCard, isdebug);
            }
            RowItemImpl rowItem = null;
            if (rowMap.containsKey(rowNumber)) {
                rowItem = (RowItemImpl)rowMap.get(rowNumber);
            } else {
                rowItem = new RowItemImpl();
                rowItem.setRowNumber(rowNumber);
                rowMap.put(rowNumber, rowItem);
            }
            if (scoreValue.getName().equals("scoring_value")) {
                rowItem.setScore(scoreValue.getValue());
                rowItem.setWeight(scoreValue.getWeight());
                continue;
            }
            CellItem cellItem = new CellItem(scoreValue.getName(), scoreValue.getValue());
            rowItem.addCellItem(cellItem);
        }
        ArrayList<RowItem> items = new ArrayList<RowItem>();
        items.addAll(rowMap.values());
        ScorecardImpl card = new ScorecardImpl(this.getName(), items, isdebug);
        Object actualScore = null;
        if (this.scoringType.equals((Object)ScoringType.sum)) {
            actualScore = card.executeSum(context);
        } else if (this.scoringType.equals((Object)ScoringType.weightsum)) {
            actualScore = card.executeWeightSum(context);
        } else if (this.scoringType.equals((Object)ScoringType.custom)) {
            if (isdebug && Utils.isDebug()) {
                String msg = "---\u6267\u884c\u81ea\u5b9a\u4e49\u8bc4\u5206\u5361\u5f97\u5206\u8ba1\u7b97Bean:" + this.scoringBean;
                context.debugMsg(msg, MsgType.ScoreCard, isdebug);
            }
            ScoringStrategy scoringStrategy = (ScoringStrategy)context.getApplicationContext().getBean(this.scoringBean);
            actualScore = scoringStrategy.calculate(card, context);
        }
        if (this.assignTargetType.equals((Object)AssignTargetType.none)) {
            this.log.warn((Object)("Scorecard [" + card.getName() + "] not setting assignment object for score value, score value is :" + actualScore));
        } else {
            Object targetFact = null;
            ValueCompute valueCompute = context.getValueCompute();
            String className = context.getVariableCategoryClass(this.variableCategory);
            targetFact = className.equals(HashMap.class.getName()) ? session.getParameters() : valueCompute.findObject(className, matchedObject, context);
            if (targetFact == null) {
                throw new RuleException("Class[" + className + "] not found in workingmemory.");
            }
            actualScore = this.datatype.convert(actualScore);
            Utils.setObjectProperty(targetFact, this.variableName, actualScore);
        }
        parentSession.getParameters().putAll(session.getParameters());
        return null;
    }

    public ScoringType getScoringType() {
        return this.scoringType;
    }

    public void setScoringType(ScoringType scoringType) {
        this.scoringType = scoringType;
    }

    public String getScoringBean() {
        return this.scoringBean;
    }

    public void setScoringBean(String scoringBean) {
        this.scoringBean = scoringBean;
    }

    public AssignTargetType getAssignTargetType() {
        return this.assignTargetType;
    }

    public void setAssignTargetType(AssignTargetType assignTargetType) {
        this.assignTargetType = assignTargetType;
    }

    public String getVariableCategory() {
        return this.variableCategory;
    }

    public void setVariableCategory(String variableCategory) {
        this.variableCategory = variableCategory;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public String getVariableLabel() {
        return this.variableLabel;
    }

    public void setVariableLabel(String variableLabel) {
        this.variableLabel = variableLabel;
    }

    public Datatype getDatatype() {
        return this.datatype;
    }

    public void setDatatype(Datatype datatype) {
        this.datatype = datatype;
    }

    public List<Library> getLibraries() {
        return this.libraries;
    }

    public void setLibraries(List<Library> libraries) {
        this.libraries = libraries;
    }

    public KnowledgePackageWrapper getKnowledgePackageWrapper() {
        return this.knowledgePackageWrapper;
    }

    public void setKnowledgePackageWrapper(KnowledgePackageWrapper knowledgePackageWrapper) {
        this.knowledgePackageWrapper = knowledgePackageWrapper;
    }
}

