/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.model.rule.loop;

import com.bstek.urule.action.Action;
import com.bstek.urule.action.ActionValue;
import com.bstek.urule.model.GeneralEntity;
import com.bstek.urule.model.rule.Rule;
import com.bstek.urule.model.rule.loop.LoopEnd;
import com.bstek.urule.model.rule.loop.LoopStart;
import com.bstek.urule.model.rule.loop.LoopTarget;
import com.bstek.urule.runtime.KnowledgePackageWrapper;
import com.bstek.urule.runtime.KnowledgeSession;
import com.bstek.urule.runtime.KnowledgeSessionFactory;
import com.bstek.urule.runtime.response.RuleExecutionResponse;
import com.bstek.urule.runtime.rete.Context;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoopRule
extends Rule {
    private LoopStart loopStart;
    private LoopEnd loopEnd;
    private LoopTarget loopTarget;
    private KnowledgePackageWrapper knowledgePackageWrapper;
    private Log log = LogFactory.getLog(this.getClass());

    public LoopRule() {
        this.setLoopRule(true);
    }

    public List<ActionValue> execute(Context context, Object matchedObject, List<Object> allMatchedObjects, Map<String, Object> variableMap) {
        List<Action> endActions;
        List<Action> startActions;
        Object loopTargetObj = context.getValueCompute().complexValueCompute(this.loopTarget.getValue(), matchedObject, context, allMatchedObjects, variableMap);
        if (loopTargetObj == null) {
            this.log.warn((Object)("Loop rule [" + this.getName() + "] target value is null,cannot be executed."));
            return null;
        }
        ArrayList<ActionValue> values = new ArrayList<ActionValue>();
        KnowledgeSession parentSession = (KnowledgeSession)context.getWorkingMemory();
        List<Object> facts = parentSession.getAllFacts();
        Map<String, Object> parameters = parentSession.getParameters();
        if (this.loopStart != null && (startActions = this.loopStart.getActions()) != null) {
            for (Action action : startActions) {
                Object value;
                if (this.getDebug() != null) {
                    action.setDebug(this.getDebug());
                }
                if ((value = action.execute(context, matchedObject, allMatchedObjects, variableMap)) == null) continue;
                values.add((ActionValue)value);
            }
        }
        KnowledgeSession session = KnowledgeSessionFactory.newKnowledgeSession(this.knowledgePackageWrapper.getKnowledgePackage(), context.getDebugMessageItems());
        if (loopTargetObj instanceof Collection) {
            Collection collections = (Collection)loopTargetObj;
            String loopClazz = null;
            for (Object object : collections) {
                if (loopClazz == null) {
                    loopClazz = object instanceof GeneralEntity ? ((GeneralEntity)object).getTargetClass() : object.getClass().getName();
                }
                for (Object fact : facts) {
                    String clazz = null;
                    clazz = fact instanceof GeneralEntity ? ((GeneralEntity)fact).getTargetClass() : fact.getClass().getName();
                    if (loopClazz.equals(clazz)) continue;
                    session.insert(fact);
                }
                session.insert(object);
                RuleExecutionResponse response = session.fireRules(parameters);
                List<ActionValue> list = response.getActionValues();
                boolean needBreak = false;
                if (list != null) {
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        ActionValue av = (ActionValue)iterator.next();
                        if (av.getActionId().equals("_loop_break__")) {
                            needBreak = true;
                            continue;
                        }
                        values.add(av);
                    }
                }
                parameters = new HashMap<String, Object>();
                parameters.putAll(session.getParameters());
                if (!needBreak) continue;
                break;
            }
        } else if (loopTargetObj instanceof Object[]) {
            Object[] objs = (Object[])loopTargetObj;
            for (Object object : objs) {
                for (Object fact : facts) {
                    session.insert(fact);
                }
                session.insert(object);
                RuleExecutionResponse response = session.fireRules();
                List<ActionValue> list = response.getActionValues();
                boolean needBreak = false;
                if (list != null) {
                    for (ActionValue av : list) {
                        if (av.getActionId().equals("_loop_break__")) {
                            needBreak = true;
                            continue;
                        }
                        values.add(av);
                    }
                }
                parameters = new HashMap<String, Object>();
                parameters.putAll(session.getParameters());
                if (!needBreak) {
                    continue;
                }
                break;
            }
        } else {
            throw new RuntimeException("Loop rule target variable must be Collection or Object array type.");
        }
        parentSession.getParameters().putAll(parameters);
        if (this.loopEnd != null && (endActions = this.loopEnd.getActions()) != null) {
            for (Action action : endActions) {
                ActionValue value;
                if (this.getDebug() != null) {
                    action.setDebug(this.getDebug());
                }
                if ((value = action.execute(context, matchedObject, allMatchedObjects, variableMap)) == null) continue;
                values.add(value);
            }
        }
        return values;
    }

    public LoopStart getLoopStart() {
        return this.loopStart;
    }

    public void setLoopStart(LoopStart loopStart) {
        this.loopStart = loopStart;
    }

    public LoopEnd getLoopEnd() {
        return this.loopEnd;
    }

    public void setLoopEnd(LoopEnd loopEnd) {
        this.loopEnd = loopEnd;
    }

    public LoopTarget getLoopTarget() {
        return this.loopTarget;
    }

    public void setLoopTarget(LoopTarget loopTarget) {
        this.loopTarget = loopTarget;
    }

    public KnowledgePackageWrapper getKnowledgePackageWrapper() {
        return this.knowledgePackageWrapper;
    }

    public void setKnowledgePackageWrapper(KnowledgePackageWrapper knowledgePackageWrapper) {
        this.knowledgePackageWrapper = knowledgePackageWrapper;
    }
}

