/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.model.rule.lhs;

import com.bstek.urule.model.rule.lhs.JunctionType;
import com.bstek.urule.model.rule.lhs.PropertyCriteria;
import com.bstek.urule.runtime.rete.EvaluationContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MultiCondition {
    private String id;
    private List<PropertyCriteria> conditions;
    private JunctionType type = JunctionType.and;

    public boolean evaluate(EvaluationContext context, Object obj, List<Object> allMatchedObjects) {
        if (this.type.equals((Object)JunctionType.and)) {
            for (PropertyCriteria criteria : this.conditions) {
                boolean value = criteria.evaluate(context, obj, allMatchedObjects);
                if (value) continue;
                return false;
            }
        } else {
            PropertyCriteria criteria;
            boolean value;
            Iterator<PropertyCriteria> iterator = this.conditions.iterator();
            while (iterator.hasNext() && !(value = (criteria = iterator.next()).evaluate(context, obj, allMatchedObjects))) {
            }
        }
        return true;
    }

    public void addCondition(PropertyCriteria condition) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<PropertyCriteria>();
        }
        this.conditions.add(condition);
    }

    public List<PropertyCriteria> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<PropertyCriteria> conditions) {
        this.conditions = conditions;
    }

    public JunctionType getType() {
        return this.type;
    }

    public void setType(JunctionType type) {
        this.type = type;
    }

    public String getId() {
        if (this.id == null) {
            for (PropertyCriteria criteria : this.conditions) {
                if (this.id == null) {
                    this.id = criteria.getId();
                    continue;
                }
                this.id = this.id + this.type.name() + " " + criteria.getId();
            }
        }
        return this.id;
    }
}

