/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.model.rule.lhs;

import com.bstek.urule.model.rule.lhs.AllLeftPart;
import com.bstek.urule.model.rule.lhs.ExprValue;
import com.bstek.urule.model.rule.lhs.StatisticType;
import com.bstek.urule.runtime.rete.EvaluationContext;
import java.math.BigDecimal;
import java.util.List;

public class ExistLeftPart
extends AllLeftPart {
    @Override
    public boolean evaluate(EvaluationContext context, Object obj, List<Object> allMatchedObjects) {
        ExprValue value = this.computeValue(context, obj, allMatchedObjects);
        int total = value.getTotal();
        int match = value.getMatch();
        switch (this.statisticType) {
            case none: {
                return match > 0;
            }
            case amount: {
                return match >= this.amount;
            }
            case percent: {
                BigDecimal left = new BigDecimal(match);
                BigDecimal currentPercent = left.divide(new BigDecimal(total), 4, 4);
                int result = currentPercent.compareTo(new BigDecimal(this.percent).divide(new BigDecimal(100)));
                return result != -1;
            }
        }
        return false;
    }

    @Override
    public String getId() {
        if (this.id == null) {
            this.id = "all(" + this.variableCategory + "." + this.variableLabel + "," + this.multiCondition.getId();
            this.id = this.statisticType.equals((Object)StatisticType.amount) ? this.id + "," + this.amount + ")" : (this.statisticType.equals((Object)StatisticType.percent) ? this.id + "," + this.percent + "%)" : this.id + ")");
        }
        return this.id;
    }
}

