/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.model.rule.lhs;

import com.bstek.urule.RuleException;
import com.bstek.urule.Utils;
import com.bstek.urule.action.ActionValue;
import com.bstek.urule.action.ExecuteMethodAction;
import com.bstek.urule.model.library.Datatype;
import com.bstek.urule.model.rule.Op;
import com.bstek.urule.model.rule.SimpleArithmetic;
import com.bstek.urule.model.rule.Value;
import com.bstek.urule.model.rule.lhs.AllLeftPart;
import com.bstek.urule.model.rule.lhs.BaseCriteria;
import com.bstek.urule.model.rule.lhs.BaseCriterion;
import com.bstek.urule.model.rule.lhs.CollectLeftPart;
import com.bstek.urule.model.rule.lhs.CommonFunctionLeftPart;
import com.bstek.urule.model.rule.lhs.EvaluateResponse;
import com.bstek.urule.model.rule.lhs.ExistLeftPart;
import com.bstek.urule.model.rule.lhs.Left;
import com.bstek.urule.model.rule.lhs.LeftPart;
import com.bstek.urule.model.rule.lhs.MethodLeftPart;
import com.bstek.urule.model.rule.lhs.VariableLeftPart;
import com.bstek.urule.runtime.rete.EvaluationContext;
import com.bstek.urule.runtime.rete.ValueCompute;
import java.util.List;
import org.codehaus.jackson.annotate.JsonIgnore;

public class Criteria
extends BaseCriterion
implements BaseCriteria {
    @JsonIgnore
    private String id;
    private Op op;
    private Left left;
    private Value value;

    @Override
    public EvaluateResponse evaluate(EvaluationContext context, Object obj, List<Object> allMatchedObjects) {
        Datatype datatype = null;
        Object leftResult = null;
        LeftPart leftPart = this.left.getLeftPart();
        String leftId = this.left.getId();
        ValueCompute valueCompute = context.getValueCompute();
        if (context.partValueExist(leftId)) {
            leftResult = context.getPartValue(leftId);
            if (leftPart instanceof VariableLeftPart) {
                datatype = ((VariableLeftPart)leftPart).getDatatype();
            }
        } else {
            Object leftValue = null;
            if (leftPart instanceof VariableLeftPart) {
                VariableLeftPart varPart = (VariableLeftPart)leftPart;
                datatype = varPart.getDatatype();
                if (varPart.getVariableName() == null) {
                    throw new RuleException("Criteria left[variableName] can not be null.");
                }
                leftValue = Utils.getObjectProperty(obj, varPart.getVariableName());
            } else if (leftPart instanceof MethodLeftPart) {
                MethodLeftPart methodPart = (MethodLeftPart)leftPart;
                ExecuteMethodAction methodAction = new ExecuteMethodAction();
                methodAction.setBeanId(methodPart.getBeanId());
                methodAction.setBeanLabel(methodPart.getBeanLabel());
                methodAction.setMethodLabel(methodPart.getMethodLabel());
                methodAction.setMethodName(methodPart.getMethodName());
                methodAction.setParameters(methodPart.getParameters());
                ActionValue actionValue = methodAction.execute(context, obj, allMatchedObjects, null);
                leftValue = actionValue == null ? null : actionValue.getValue();
            } else if (leftPart instanceof ExistLeftPart) {
                ExistLeftPart existPart = (ExistLeftPart)leftPart;
                leftValue = existPart.evaluate(context, obj, allMatchedObjects);
            } else if (leftPart instanceof AllLeftPart) {
                AllLeftPart allPart = (AllLeftPart)leftPart;
                leftValue = allPart.evaluate(context, obj, allMatchedObjects);
            } else if (leftPart instanceof CollectLeftPart) {
                CollectLeftPart collectPart = (CollectLeftPart)leftPart;
                leftValue = collectPart.evaluate(context, obj, allMatchedObjects);
            } else if (leftPart instanceof CommonFunctionLeftPart) {
                CommonFunctionLeftPart part = (CommonFunctionLeftPart)leftPart;
                leftValue = part.evaluate(context, obj, allMatchedObjects);
            }
            leftResult = leftValue;
            SimpleArithmetic arithmetic = this.left.getArithmetic();
            if (arithmetic != null) {
                leftResult = valueCompute.simpleArithmeticCompute(context, leftValue, arithmetic);
            }
            context.storePartValue(leftId, leftResult);
        }
        EvaluateResponse response = new EvaluateResponse();
        response.setLeftResult(leftResult);
        Object right = null;
        if (this.value != null) {
            String valueId = this.value.getId();
            if (context.partValueExist(valueId)) {
                right = context.getPartValue(valueId);
            } else {
                right = valueCompute.complexValueCompute(this.value, obj, context, allMatchedObjects, null);
                response.setRightResult(right);
                context.storePartValue(valueId, right);
            }
        }
        if (datatype == null) {
            datatype = Utils.getDatatype(leftResult);
        }
        boolean result = context.getAssertorEvaluator().evaluate(leftResult, right, datatype, this.op);
        response.setResult(result);
        return response;
    }

    @Override
    public String getId() {
        if (this.id == null) {
            this.id = this.left.getId() + "\u3010" + this.op.toString() + "\u3011";
            if (this.value != null) {
                this.id = this.id + this.value.getId();
            }
        }
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Op getOp() {
        return this.op;
    }

    public void setOp(Op op) {
        this.op = op;
    }

    public Left getLeft() {
        return this.left;
    }

    public void setLeft(Left left) {
        this.left = left;
    }

    public Value getValue() {
        return this.value;
    }

    public void setValue(Value value) {
        this.value = value;
    }
}

