/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.model.rule.lhs;

import com.bstek.urule.Utils;
import com.bstek.urule.model.rule.lhs.AbstractLeftPart;
import com.bstek.urule.model.rule.lhs.CollectPurpose;
import com.bstek.urule.model.rule.lhs.ExprValue;
import com.bstek.urule.runtime.rete.EvaluationContext;
import java.math.BigDecimal;
import java.util.List;

public class CollectLeftPart
extends AbstractLeftPart {
    private String property;
    private CollectPurpose purpose;

    public Object evaluate(EvaluationContext context, Object obj, List<Object> allMatchedObjects) {
        ExprValue value = this.computeValue(context, obj, allMatchedObjects);
        int match = value.getMatch();
        List<Object> facts = value.getFacts();
        if (this.purpose.equals((Object)CollectPurpose.count)) {
            return match;
        }
        if (this.purpose.equals((Object)CollectPurpose.avg)) {
            BigDecimal total = new BigDecimal(0);
            for (Object fact : facts) {
                Object propertyValue = Utils.getObjectProperty(fact, this.property);
                total = total.add(Utils.toBigDecimal(propertyValue));
            }
            return total.divide(new BigDecimal(match), 4, 4);
        }
        if (this.purpose.equals((Object)CollectPurpose.sum)) {
            BigDecimal total = new BigDecimal(0);
            for (Object fact : facts) {
                Object propertyValue = Utils.getObjectProperty(fact, this.property);
                total = total.add(Utils.toBigDecimal(propertyValue));
            }
            return total;
        }
        if (this.purpose.equals((Object)CollectPurpose.max)) {
            BigDecimal max = new BigDecimal(0);
            for (Object fact : facts) {
                Object propertyValue = Utils.getObjectProperty(fact, this.property);
                BigDecimal decValue = Utils.toBigDecimal(propertyValue);
                int result = decValue.compareTo(max);
                if (result != 1) continue;
                max = decValue;
            }
            return max;
        }
        if (this.purpose.equals((Object)CollectPurpose.min)) {
            BigDecimal min = null;
            for (Object fact : facts) {
                Object propertyValue = Utils.getObjectProperty(fact, this.property);
                BigDecimal decValue = Utils.toBigDecimal(propertyValue);
                if (min != null) {
                    int result = decValue.compareTo(min);
                    if (result != -1) continue;
                    min = decValue;
                    continue;
                }
                min = decValue;
            }
            return min;
        }
        return 0;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public CollectPurpose getPurpose() {
        return this.purpose;
    }

    public void setPurpose(CollectPurpose purpose) {
        this.purpose = purpose;
    }

    @Override
    public String getId() {
        if (this.id == null) {
            this.id = "collect(" + this.variableCategory + "." + this.variableLabel + ",";
            this.id = this.multiCondition != null ? this.id + this.multiCondition.getId() + ")" : this.id + ")";
            this.id = this.purpose.equals((Object)CollectPurpose.count) ? this.id + "." + this.purpose.name() : this.id + "." + this.property + "." + this.purpose.name();
        }
        return this.id;
    }
}

