/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.model.rule.lhs;

import com.bstek.urule.model.rule.lhs.AbstractLeftPart;
import com.bstek.urule.model.rule.lhs.ExprValue;
import com.bstek.urule.model.rule.lhs.StatisticType;
import com.bstek.urule.runtime.rete.EvaluationContext;
import java.math.BigDecimal;
import java.util.List;

public class AllLeftPart
extends AbstractLeftPart {
    protected int amount;
    protected int percent;
    protected StatisticType statisticType = StatisticType.none;

    public boolean evaluate(EvaluationContext context, Object obj, List<Object> allMatchedObjects) {
        ExprValue value = this.computeValue(context, obj, allMatchedObjects);
        int total = value.getTotal();
        int match = value.getMatch();
        int notMatch = value.getNotMatch();
        switch (this.statisticType) {
            case none: {
                return notMatch == 0;
            }
            case amount: {
                return match == this.amount;
            }
            case percent: {
                BigDecimal left = new BigDecimal(match);
                BigDecimal currentPercent = left.divide(new BigDecimal(total), 4, 4);
                int result = currentPercent.compareTo(new BigDecimal(this.percent).divide(new BigDecimal(100)));
                return result == 0;
            }
        }
        return false;
    }

    @Override
    public String getId() {
        if (this.id == null) {
            this.id = "all(" + this.variableCategory + "." + this.variableLabel + "," + this.multiCondition.getId() + ")";
        }
        return this.id;
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public int getPercent() {
        return this.percent;
    }

    public void setPercent(int percent) {
        this.percent = percent;
    }

    public StatisticType getStatisticType() {
        return this.statisticType;
    }

    public void setStatisticType(StatisticType statisticType) {
        this.statisticType = statisticType;
    }
}

