/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.model.rete.jsondeserializer;

import com.bstek.urule.model.library.Datatype;
import com.bstek.urule.model.rete.JsonUtils;
import com.bstek.urule.model.rete.jsondeserializer.ValueDeserializer;
import com.bstek.urule.model.rule.NamedReferenceValue;
import com.bstek.urule.model.rule.Value;
import com.bstek.urule.model.rule.ValueType;
import org.codehaus.jackson.JsonNode;

public class NameReferenceValueDeserializer
implements ValueDeserializer {
    @Override
    public Value deserialize(JsonNode jsonNode) {
        NamedReferenceValue value = new NamedReferenceValue();
        value.setArithmetic(JsonUtils.parseComplexArithmetic(jsonNode));
        String datatypeText = JsonUtils.getJsonValue(jsonNode, "datatype");
        if (datatypeText != null) {
            value.setDatatype(Datatype.valueOf(datatypeText));
        }
        value.setReferenceName(JsonUtils.getJsonValue(jsonNode, "referenceName"));
        value.setPropertyLabel(JsonUtils.getJsonValue(jsonNode, "propertyLabel"));
        value.setPropertyName(JsonUtils.getJsonValue(jsonNode, "propertyName"));
        return value;
    }

    @Override
    public boolean support(ValueType type) {
        return type.equals((Object)ValueType.NamedReference);
    }
}

